/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;
import org.owasp.encoder.Encode;

@HopServerServlet(id="prepareExec", name="Prepare the execution of a pipeline")
public class PrepareExecutionPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = PrepareExecutionPipelineServlet.class;
    private static final String CONST_NAME = "?name=";
    private static final String CONST_HEADER_CLOSE = "</H1>";
    private static final String CONST_HEADER_OPEN = "<H1>";
    private static final String CONST_LINK_OPEN = "<a href=\"";
    private static final String CONST_LINK_CLOSE = "</a><p>";
    private static final String CONST_CLOSE_TAG = "\">";
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/prepareExec";

    public PrepareExecutionPipelineServlet() {
    }

    public PrepareExecutionPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        boolean useXML;
        block19: {
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.PipelinePrepareExecutionRequested", (String[])new String[0]));
            }
            String pipelineName = request.getParameter("name");
            String id = request.getParameter("id");
            useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
            response.setStatus(200);
            out = response.getWriter();
            if (useXML) {
                response.setContentType("text/xml");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
            } else {
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.PipelinePrepareExecution", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=" + this.convertContextPath("/hop/pipelineStatus") + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + CONST_CLOSE_TAG);
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            try {
                IPipelineEngine<PipelineMeta> pipeline;
                HopServerObjectEntry entry;
                if (Utils.isEmpty((CharSequence)id)) {
                    entry = this.getPipelineMap().getFirstServerObjectEntry(pipelineName);
                    if (entry == null) {
                        pipeline = null;
                    } else {
                        id = entry.getId();
                        pipeline = this.getPipelineMap().getPipeline(entry);
                    }
                } else {
                    entry = new HopServerObjectEntry(pipelineName, id);
                    pipeline = this.getPipelineMap().getPipeline(entry);
                }
                PipelineConfiguration pipelineConfiguration = this.getPipelineMap().getConfiguration(entry);
                if (pipeline != null && pipelineConfiguration != null) {
                    PipelineExecutionConfiguration executionConfiguration = pipelineConfiguration.getPipelineExecutionConfiguration();
                    pipeline.setVariables(executionConfiguration.getVariablesMap());
                    pipeline.setPreviousResult(executionConfiguration.getPreviousResult());
                    try {
                        pipeline.prepareExecution();
                        if (useXML) {
                            out.println(WebResult.OK.getXml());
                            break block19;
                        }
                        out.println(CONST_HEADER_OPEN + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.PipelinePrepared", (String[])new String[]{pipelineName})) + CONST_HEADER_CLOSE);
                        out.println(CONST_LINK_OPEN + this.convertContextPath("/hop/pipelineStatus") + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + "&id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + CONST_CLOSE_TAG + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToPipelineStatusPage", (String[])new String[0]) + CONST_LINK_CLOSE);
                    }
                    catch (Throwable e) {
                        String logText = HopLogStore.getAppender().getBuffer(pipeline.getLogChannel().getLogChannelId(), true).toString();
                        if (useXML) {
                            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.Error.PipelineInitFailed", (String[])new String[]{Const.CR + logText + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e)})));
                            break block19;
                        }
                        out.println(CONST_HEADER_OPEN + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.Log.PipelineNotInit", (String[])new String[]{pipelineName})) + CONST_HEADER_CLOSE);
                        out.println("<pre>");
                        out.println(Encode.forHtml((String)logText));
                        out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)e)));
                        out.println("</pre>");
                        out.println(CONST_LINK_OPEN + this.convertContextPath("/hop/pipelineStatus") + CONST_NAME + URLEncoder.encode(pipelineName, StandardCharsets.UTF_8) + "&id=" + URLEncoder.encode(id, StandardCharsets.UTF_8) + CONST_CLOSE_TAG + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToPipelineStatusPage", (String[])new String[0]) + CONST_LINK_CLOSE);
                        response.setStatus(400);
                    }
                    break block19;
                }
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindSpecPipeline", (String[])new String[]{pipelineName})));
                } else {
                    out.println(CONST_HEADER_OPEN + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"PipelineStatusServlet.Log.CoundNotFindPipeline", (String[])new String[]{pipelineName})) + CONST_HEADER_CLOSE);
                    out.println(CONST_LINK_OPEN + this.convertContextPath("/hop/status") + CONST_CLOSE_TAG + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + CONST_LINK_CLOSE);
                    response.setStatus(400);
                }
            }
            catch (Exception ex) {
                if (useXML) {
                    out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"PrepareExecutionPipelineServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
                }
                out.println("<p>");
                out.println("<pre>");
                out.println(Encode.forHtml((String)Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
                response.setStatus(400);
            }
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Start pipeline";
    }

    @Override
    public String getService() {
        return "/hop/prepareExec (" + this + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

