/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.HopServerPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WorkflowMap;

public class HopServerServlet
extends HttpServlet {
    private static final long serialVersionUID = 2434694833497859776L;
    public static final String STRING_HOP_SERVER_SERVLET = "HopServer Servlet";
    private Map<String, IHopServerPlugin> hopServerPluginRegistry;
    private final ILogChannel log = new LogChannel((Object)"HopServer Servlet");

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IHopServerPlugin plugin;
        String servletPath = req.getPathInfo();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ((plugin = this.hopServerPluginRegistry.get(servletPath)) != null) {
            try {
                plugin.doGet(req, resp);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            if (this.log.isDebug()) {
                this.log.logDebug("Unable to find Hop Server Plugin for key: /hop" + req.getPathInfo());
            }
            resp.sendError(404);
        }
    }

    private String getServletKey(IHopServerPlugin servlet) {
        String key = servlet.getContextPath();
        if (key.startsWith("/hop")) {
            key = key.substring("/hop".length());
        }
        return key;
    }

    public void init(ServletConfig config) throws ServletException {
        this.hopServerPluginRegistry = new ConcurrentHashMap<String, IHopServerPlugin>();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(HopServerPluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                this.registerServlet(this.loadServlet(plugin));
            }
            catch (HopPluginException e) {
                this.log.logError("Unable to instantiate plugin for use with HopServerServlet " + plugin.getName());
            }
        }
        Enumeration initParameterNames = config.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String paramName = (String)initParameterNames.nextElement();
            String className = config.getInitParameter(paramName);
            try {
                Class<?> clazz = Class.forName(className);
                this.registerServlet((IHopServerPlugin)clazz.newInstance());
            }
            catch (ClassNotFoundException e) {
                this.log.logError("Unable to find configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.logError("Unable to instantiate configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.logError("Unable to access configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (ClassCastException e) {
                this.log.logError("Unable to cast configured " + paramName + " of " + className + " to " + IHopServerPlugin.class, (Throwable)e);
            }
        }
        pluginRegistry.addPluginListener(HopServerPluginType.class, new IPluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                try {
                    HopServerServlet.this.registerServlet(HopServerServlet.this.loadServlet((IPlugin)serviceObject));
                }
                catch (HopPluginException e) {
                    HopServerServlet.this.log.logError(MessageFormat.format("Unable to load plugin: {0}", serviceObject), (Throwable)e);
                }
            }

            public void pluginRemoved(Object serviceObject) {
                try {
                    String key = HopServerServlet.this.getServletKey(HopServerServlet.this.loadServlet((IPlugin)serviceObject));
                    HopServerServlet.this.hopServerPluginRegistry.remove(key);
                }
                catch (HopPluginException e) {
                    HopServerServlet.this.log.logError(MessageFormat.format("Unable to load plugin: {0}", serviceObject), (Throwable)e);
                }
            }

            public void pluginChanged(Object serviceObject) {
                this.pluginAdded(serviceObject);
            }
        });
    }

    private IHopServerPlugin loadServlet(IPlugin plugin) throws HopPluginException {
        return (IHopServerPlugin)PluginRegistry.getInstance().loadClass(plugin, IHopServerPlugin.class);
    }

    private void registerServlet(IHopServerPlugin servlet) {
        PipelineMap pipelineMap = HopServerSingleton.getInstance().getPipelineMap();
        WorkflowMap workflowMap = HopServerSingleton.getInstance().getWorkflowMap();
        this.hopServerPluginRegistry.put(this.getServletKey(servlet), servlet);
        servlet.setup(pipelineMap, workflowMap);
        servlet.setJettyMode(false);
    }
}

