/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;

class IdentityFile
implements Identity {
    private KeyPair kpair;
    private String identity;

    static IdentityFile newInstance(String prvfile, String pubfile, JSch.InstanceLogger instLogger) throws JSchException {
        KeyPair kpair = KeyPair.load(instLogger, prvfile, pubfile);
        return new IdentityFile(prvfile, kpair);
    }

    static IdentityFile newInstance(String name, byte[] prvkey, byte[] pubkey, JSch.InstanceLogger instLogger) throws JSchException {
        KeyPair kpair = KeyPair.load(instLogger, prvkey, pubkey);
        return new IdentityFile(name, kpair);
    }

    private IdentityFile(String name, KeyPair kpair) {
        this.identity = name;
        this.kpair = kpair;
    }

    @Override
    public boolean setPassphrase(byte[] passphrase) throws JSchException {
        return this.kpair.decrypt(passphrase);
    }

    @Override
    public byte[] getPublicKeyBlob() {
        return this.kpair.getPublicKeyBlob();
    }

    @Override
    public byte[] getSignature(byte[] data) {
        return this.kpair.getSignature(data);
    }

    @Override
    public byte[] getSignature(byte[] data, String alg) {
        return this.kpair.getSignature(data, alg);
    }

    @Override
    public String getAlgName() {
        return this.kpair.getKeyTypeString();
    }

    @Override
    public String getName() {
        return this.identity;
    }

    @Override
    public boolean isEncrypted() {
        return this.kpair.isEncrypted();
    }

    @Override
    public void clear() {
        this.kpair.dispose();
        this.kpair = null;
    }

    public KeyPair getKeyPair() {
        return this.kpair;
    }
}

