/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.GetInsightRuleReportRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class GetInsightRuleReportRequestMarshaller
implements Marshaller<Request<GetInsightRuleReportRequest>, GetInsightRuleReportRequest> {
    public Request<GetInsightRuleReportRequest> marshall(GetInsightRuleReportRequest getInsightRuleReportRequest) {
        if (getInsightRuleReportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getInsightRuleReportRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetInsightRuleReport");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getInsightRuleReportRequest.getRuleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString((String)getInsightRuleReportRequest.getRuleName()));
        }
        if (getInsightRuleReportRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getInsightRuleReportRequest.getStartTime()));
        }
        if (getInsightRuleReportRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getInsightRuleReportRequest.getEndTime()));
        }
        if (getInsightRuleReportRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)getInsightRuleReportRequest.getPeriod()));
        }
        if (getInsightRuleReportRequest.getMaxContributorCount() != null) {
            request.addParameter("MaxContributorCount", StringUtils.fromInteger((Integer)getInsightRuleReportRequest.getMaxContributorCount()));
        }
        if (!getInsightRuleReportRequest.getMetrics().isEmpty() || !((SdkInternalList)getInsightRuleReportRequest.getMetrics()).isAutoConstruct()) {
            SdkInternalList metricsList = (SdkInternalList)getInsightRuleReportRequest.getMetrics();
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        if (getInsightRuleReportRequest.getOrderBy() != null) {
            request.addParameter("OrderBy", StringUtils.fromString((String)getInsightRuleReportRequest.getOrderBy()));
        }
        return request;
    }
}

