/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadUploader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.dropbox.DropboxFileSystem;

public class DropboxFileObject
extends AbstractFileObject<DropboxFileSystem> {
    private final DbxClientV2 client;
    private Metadata metadata;

    protected DropboxFileObject(AbstractFileName name, DropboxFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.client = fileSystem.getClient();
        this.injectType(FileType.IMAGINARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAttach() throws FileSystemException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.getParent() == null) {
                this.injectType(FileType.FOLDER);
                return;
            }
            if (this.metadata == null) {
                try {
                    String path = this.getName().getPath();
                    this.metadata = this.client.files().getMetadata(path);
                }
                catch (DbxException dbxException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetach() throws FileSystemException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.metadata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.metadata == null) {
                return FileType.IMAGINARY;
            }
            return this.metadata instanceof FileMetadata ? FileType.FILE : FileType.FOLDER;
        }
    }

    private List<Metadata> doGetChildren() throws IOException {
        ArrayList<Metadata> childrens = new ArrayList<Metadata>();
        try {
            String path = this.getName().getPath();
            if ("/".equals(path)) {
                path = "";
            }
            ListFolderResult result = this.client.files().listFolder(path);
            while (true) {
                childrens.addAll(result.getEntries());
                if (result.getHasMore()) {
                    result = this.client.files().listFolderContinue(result.getCursor());
                    continue;
                }
                break;
            }
        }
        catch (DbxException e) {
            throw new FileSystemException("vfs.provider/list-children.error", (Object)this.getName(), (Throwable)e);
        }
        return childrens;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        List<Metadata> childrens = this.doGetChildren();
        FileObject[] result = new FileObject[childrens.size()];
        int i = 0;
        DropboxFileSystem fileSystem = (DropboxFileSystem)this.getAbstractFileSystem();
        for (Metadata metadata : childrens) {
            DropboxFileObject file = (DropboxFileObject)fileSystem.resolveFile(metadata.getPathDisplay());
            if (file == null) continue;
            file.metadata = metadata;
            result[i++] = file;
        }
        return result;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected void doDelete() throws Exception {
        String path = this.getName().getPath();
        this.client.files().deleteV2(path);
    }

    protected void doRename(FileObject newFile) throws Exception {
        String fromPath = this.getName().getPath();
        String toPath = newFile.getName().getPath();
        this.client.files().moveV2(fromPath, toPath);
    }

    protected void doCreateFolder() throws Exception {
        String path = this.getName().getPath();
        this.client.files().createFolderV2(path);
    }

    protected long doGetContentSize() {
        Metadata metadata = this.metadata;
        if (metadata instanceof FileMetadata) {
            FileMetadata fileMetadata = (FileMetadata)metadata;
            return fileMetadata.getSize();
        }
        return 0L;
    }

    protected long doGetLastModifiedTime() {
        Metadata metadata = this.metadata;
        if (metadata instanceof FileMetadata) {
            FileMetadata fileMetadata = (FileMetadata)metadata;
            return fileMetadata.getClientModified().getTime();
        }
        return 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        String path = this.getName().getPath();
        InputStream is = this.client.files().download(path).getInputStream();
        if (is == null) {
            throw new FileNotFoundException((Object)this.getName());
        }
        return is;
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        String path = this.getName().getPath();
        if (append) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", (Object)path);
        }
        if (this.getType() == FileType.IMAGINARY) {
            return NullOutputStream.NULL_OUTPUT_STREAM;
        }
        final UploadUploader uploader = this.client.files().upload(path);
        return new FilterOutputStream(uploader.getOutputStream()){

            @Override
            public void close() throws IOException {
                try {
                    uploader.finish();
                }
                catch (Exception e) {
                    throw new IOException("Failed to upload " + DropboxFileObject.this.getName(), e);
                }
                finally {
                    uploader.close();
                }
            }
        };
    }
}

