/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights.schema;

import com.datastax.dse.driver.internal.core.insights.schema.InsightType;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class InsightMetadata {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timestamp")
    private final long timestamp;
    @JsonProperty(value="tags")
    private final Map<String, String> tags;
    @JsonProperty(value="insightType")
    private final InsightType insightType;
    @JsonProperty(value="insightMappingId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String insightMappingId;

    @JsonCreator
    public InsightMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="insightType") InsightType insightType, @JsonProperty(value="insightMappingId") String insightMappingId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is required");
        this.name = name;
        this.timestamp = timestamp;
        this.tags = tags;
        this.insightType = insightType;
        this.insightMappingId = insightMappingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsightMetadata)) {
            return false;
        }
        InsightMetadata that = (InsightMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.tags, that.tags) && this.insightType == that.insightType && Objects.equals(this.insightMappingId, that.insightMappingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.timestamp, this.tags, this.insightType, this.insightMappingId});
    }

    public String toString() {
        return "InsightMetadata{name='" + this.name + '\'' + ", timestamp=" + this.timestamp + ", tags=" + this.tags + ", insightType=" + (Object)((Object)this.insightType) + ", insightMappingId=" + this.insightMappingId + '}';
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public InsightType getInsightType() {
        return this.insightType;
    }

    public String getInsightMappingId() {
        return this.insightMappingId;
    }
}

