/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.commons.lang3.SystemUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class LocalResourceId
implements ResourceId {
    private final @UnknownKeyFor @NonNull @Initialized String pathString;
    private volatile transient @Nullable @UnknownKeyFor @Initialized Path cachedPath;

    static @UnknownKeyFor @NonNull @Initialized LocalResourceId fromPath(@UnknownKeyFor @NonNull @Initialized Path path, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        Preconditions.checkArgumentNotNull(path, "path");
        return new LocalResourceId(path, isDirectory);
    }

    private LocalResourceId(@UnknownKeyFor @NonNull @Initialized Path path, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        this.pathString = path.toAbsolutePath().normalize().toString() + (isDirectory ? File.separator : "");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LocalResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.isDirectory(), (String)"Expected the path is a directory, but had [%s].", (Object)this.pathString);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) ? 1 : 0) != 0, (String)"ResolveOptions: [%s] is not supported.", (Object)resolveOptions);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_FILE) || !other.endsWith("/") ? 1 : 0) != 0, (String)"The resolved file: [%s] should not end with '/'.", (Object)other);
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.resolveLocalPathWindowsOS(other, resolveOptions);
        }
        return this.resolveLocalPath(other, resolveOptions);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized LocalResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        Path path = this.getPath();
        Path parent = path.getParent();
        if (parent == null && path.getNameCount() == 1) {
            parent = Paths.get(".", new String[0]);
        }
        Preconditions.checkStateNotNull(parent, "Failed to get the current directory for path: [%s].", (Object)this.pathString);
        return LocalResourceId.fromPath(parent, true);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String getFilename() {
        Path fileName = this.getPath().getFileName();
        return fileName == null ? null : fileName.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized LocalResourceId resolveLocalPath(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        return new LocalResourceId(this.getPath().resolve(other), resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    private @UnknownKeyFor @NonNull @Initialized LocalResourceId resolveLocalPathWindowsOS(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        String uuid = UUID.randomUUID().toString();
        Path pathAsterisksReplaced = Paths.get(this.pathString.replaceAll("\\*", uuid), new String[0]);
        String otherAsterisksReplaced = other.replaceAll("\\*", uuid);
        return new LocalResourceId(Paths.get(pathAsterisksReplaced.resolve(otherAsterisksReplaced).toString().replaceAll(uuid, "\\*"), new String[0]), resolveOptions.equals(ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return "file";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.pathString.endsWith(File.separator);
    }

    @UnknownKeyFor @NonNull @Initialized Path getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = Paths.get(this.pathString, new String[0]);
        }
        return this.cachedPath;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.pathString;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (!(obj instanceof LocalResourceId)) {
            return false;
        }
        LocalResourceId other = (LocalResourceId)obj;
        return this.pathString.equals(other.pathString);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pathString);
    }
}

