/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;

public enum GraphPropertyDataType {
    String("string"),
    Integer("long"),
    Float("double"),
    Number("doubler"),
    Boolean("boolean"),
    Date("date"),
    LocalDateTime("localdatetime"),
    ByteArray(null),
    Time("time"),
    Point(null),
    Duration("duration"),
    LocalTime("localtime"),
    DateTime("datetime"),
    List("List"),
    Map("Map"),
    Node("Node"),
    Relationship("Relationship"),
    Path("Path");

    private String importType;

    private GraphPropertyDataType(String importType) {
        this.importType = importType;
    }

    public static String getCode(GraphPropertyDataType type) {
        if (type == null) {
            return null;
        }
        return type.name();
    }

    public static GraphPropertyDataType parseCode(String code) {
        if (code == null) {
            return String;
        }
        for (GraphPropertyDataType type : GraphPropertyDataType.values()) {
            if (!type.name().equalsIgnoreCase(code)) continue;
            return type;
        }
        return String;
    }

    public static String[] getNames() {
        String[] names = new String[GraphPropertyDataType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = GraphPropertyDataType.values()[i].name();
        }
        return names;
    }

    public static GraphPropertyDataType getTypeFromNeo4jValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return Integer;
        }
        if (object instanceof Double) {
            return Float;
        }
        if (object instanceof Number) {
            return Number;
        }
        if (object instanceof String) {
            return String;
        }
        if (object instanceof Boolean) {
            return Boolean;
        }
        if (object instanceof LocalDate) {
            return Date;
        }
        if (object instanceof LocalDateTime) {
            return LocalDateTime;
        }
        if (object instanceof LocalTime) {
            return LocalTime;
        }
        if (object instanceof Duration) {
            return Duration;
        }
        throw new RuntimeException("Unsupported object with class: " + object.getClass().getName());
    }

    public Object convertFromHop(IValueMeta valueMeta, Object valueData) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            return null;
        }
        switch (this) {
            case String: {
                return valueMeta.getString(valueData);
            }
            case Boolean: {
                return valueMeta.getBoolean(valueData);
            }
            case Float: {
                return valueMeta.getNumber(valueData);
            }
            case Integer: {
                return valueMeta.getInteger(valueData);
            }
            case Date: {
                return valueMeta.getDate(valueData).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            case LocalDateTime: {
                return valueMeta.getDate(valueData).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            case ByteArray: {
                return valueMeta.getBinary(valueData);
            }
        }
        throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' from value '" + valueMeta.toStringMeta() + "' is not supported yet");
    }

    public int getHopType() throws HopValueException {
        switch (this) {
            case String: 
            case Map: 
            case List: {
                return 2;
            }
            case Node: 
            case Relationship: 
            case Path: {
                return 303;
            }
            case Boolean: {
                return 4;
            }
            case Float: {
                return 1;
            }
            case Integer: {
                return 5;
            }
            case Date: 
            case LocalDateTime: {
                return 3;
            }
            case ByteArray: {
                return 8;
            }
        }
        throw new HopValueException("Data conversion to Neo4j type '" + this.name() + "' is not supported yet");
    }

    public static final GraphPropertyDataType getTypeFromHop(IValueMeta valueMeta) {
        switch (valueMeta.getType()) {
            case 2: {
                return String;
            }
            case 1: {
                return Float;
            }
            case 3: {
                return LocalDateTime;
            }
            case 9: {
                return LocalDateTime;
            }
            case 4: {
                return Boolean;
            }
            case 8: {
                return ByteArray;
            }
            case 6: {
                return String;
            }
            case 5: {
                return Integer;
            }
        }
        return String;
    }

    public String getImportType() {
        return this.importType;
    }

    public void setImportType(String importType) {
        this.importType = importType;
    }
}

