/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovyx.gpars.actor.AbstractLoopingActor;
import groovyx.gpars.actor.Actor;

final class ActorTimerTask
implements Runnable {
    private final AbstractLoopingActor actor;
    private final int id;
    private volatile boolean cancelled = false;

    ActorTimerTask(AbstractLoopingActor actor, int id) {
        this.actor = actor;
        this.id = id;
    }

    @Override
    public void run() {
        try {
            if (this.cancelled) {
                return;
            }
            this.actor.send(Actor.TIMEOUT_MESSAGE);
        }
        catch (Throwable e) {
            this.actor.handleException(e);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public int getId() {
        return this.id;
    }
}

