/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.view.markup;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Arrays;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.view.GrailsViews;
import org.grails.forge.feature.view.markup.templates._errors;
import org.grails.forge.feature.view.markup.templates._object;
import org.grails.forge.feature.view.markup.templates.error;
import org.grails.forge.feature.view.markup.templates.index;
import org.grails.forge.feature.view.markup.templates.notFound;
import org.grails.forge.feature.web.GrailsWeb;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class ViewMarkup
extends GrailsViews
implements Feature {
    public ViewMarkup(GrailsWeb grailsWeb) {
        super(grailsWeb);
    }

    @Override
    @NonNull
    public String getName() {
        return "views-markup";
    }

    @Override
    public String getTitle() {
        return "Markup Views";
    }

    @Override
    @NonNull
    public String getDescription() {
        return "Markup views are written in Groovy, end with the file extension gml and reside in the grails-app/views directory. They provide a DSL for producing output in the XML.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationConfiguration config = generatorContext.getConfiguration();
        config.put("grails.mime.disable.accept.header.userAgents", Arrays.asList("Gecko", "WebKit", "Presto", "Trident"));
        config.put("grails.mime.types.xml", Arrays.asList("text/xml", "application/xml"));
        config.put("grails.mime.types.atom", "application/atom+xml");
        config.put("grails.mime.types.json", Arrays.asList("application/json", "text/json"));
        config.put("grails.mime.types.hal", Arrays.asList("application/hal+json", "application/hal+xml"));
        config.put("grails.mime.types.css", "text/css");
        config.put("grails.mime.types.csv", "text/csv");
        config.put("grails.mime.types.js", "text/javascript");
        config.put("grails.mime.types.rss", "application/rss+xml");
        config.put("grails.mime.types.text", "text/plain");
        config.put("grails.mime.types.all", "*/*");
        generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.apache.grails.gradle.grails-markup").useApplyPlugin(true).build());
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-views-markup").implementation());
        generatorContext.addTemplate("application_index_gml", new RockerTemplate(this.getViewFolderPath() + "application/index.gml", index.template()));
        generatorContext.addTemplate("_errors_gml", new RockerTemplate(this.getViewFolderPath() + "errors/_errors.gml", _errors.template()));
        generatorContext.addTemplate("_object_gml", new RockerTemplate(this.getViewFolderPath() + "object/_object.gml", _object.template()));
        generatorContext.addTemplate("error_gml", new RockerTemplate(this.getViewFolderPath() + "error.gml", error.template()));
        generatorContext.addTemplate("notFound_gml", new RockerTemplate(this.getViewFolderPath() + "notFound.gml", notFound.template()));
    }
}

