/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.domain;
import org.grails.forge.cli.command.templates.domainSpec;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.TemplateRenderer;
import picocli.CommandLine;

@CommandLine.Command(name="create-domain-class", description={"Creates a Domain Class"})
public class CreateDomainClassCommand
extends CodeGenCommand {
    public static final String NAME = "create-domain-class";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="DOMAIN-CLASS-NAME", description={"The name of the domain class to create"})
    String domainClassName;

    @Inject
    public CreateDomainClassCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateDomainClassCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        Project project = this.getProject(this.domainClassName);
        TemplateRenderer templateRenderer = this.getTemplateRenderer(project);
        RenderResult domainRenderResult = templateRenderer.render(new RockerTemplate("grails-app/domain/{packagePath}/{className}.groovy", domain.template(project)), this.overwrite);
        RenderResult domainSpecRenderResult = templateRenderer.render(new RockerTemplate("src/test/groovy/{packagePath}/{className}Spec.groovy", domainSpec.template(project)), this.overwrite);
        if (domainRenderResult != null && domainSpecRenderResult != null) {
            this.logRenderResult(domainRenderResult);
            this.logRenderResult(domainSpecRenderResult);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered domain class to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

