/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.geode.GemFireIOException;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.logging.LogWriterImpl;

public class PureLogWriter
extends LogWriterImpl {
    private final String connectionName;
    private volatile boolean closed;
    protected volatile int level;
    private PrintWriter printWriter;
    private long bytesLogged;

    public PureLogWriter(int level) {
        this(level, System.out);
    }

    public PureLogWriter(int level, PrintStream printStream) {
        this(level, new PrintWriter(printStream, true), null);
    }

    public PureLogWriter(int level, PrintStream printStream, String connectionName) {
        this(level, new PrintWriter(printStream, true), connectionName);
    }

    public PureLogWriter(int level, PrintWriter printWriter, String connectionName) {
        this.setLevel(level);
        this.printWriter = printWriter;
        this.connectionName = connectionName;
    }

    @Override
    public int getLogWriterLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    protected String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected long getThreadId() {
        return Thread.currentThread().getId();
    }

    @Override
    public void put(int messageLevel, String message, Throwable throwable) {
        String exceptionText = null;
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            exceptionText = stringWriter.toString();
        }
        this.put(messageLevel, new Date(), this.connectionName, this.getThreadName(), this.getThreadId(), message, exceptionText);
    }

    @Override
    public void put(int messageLevel, StringId messageId, Object[] parameters, Throwable throwable) {
        String message = messageId.toLocalizedString(parameters);
        this.put(messageLevel, message, throwable);
    }

    private String formatLogLine(int messageLevel, Date messageDate, String connectionName, String threadName, long threadId, String message, String exceptionText) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printHeader(printWriter, messageLevel, messageDate, connectionName, threadName, threadId);
        if (message != null) {
            try {
                PureLogWriter.formatText(printWriter, message, 40);
            }
            catch (RuntimeException e) {
                printWriter.println(message);
                printWriter.println("Ignoring exception: ");
                e.printStackTrace(printWriter);
            }
        } else {
            printWriter.println();
        }
        if (exceptionText != null) {
            printWriter.print(exceptionText);
        }
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private void printHeader(PrintWriter printWriter, int messageLevel, Date messageDate, String connectionName, String threadName, long threadId) {
        printWriter.println();
        printWriter.print('[');
        printWriter.print(PureLogWriter.levelToString(messageLevel));
        printWriter.print(' ');
        printWriter.print(this.formatDate(messageDate));
        if (connectionName != null) {
            printWriter.print(' ');
            printWriter.print(connectionName);
        }
        if (threadName != null) {
            printWriter.print(" <");
            printWriter.print(threadName);
            printWriter.print(">");
        }
        printWriter.print(" tid=0x");
        printWriter.print(Long.toHexString(threadId));
        printWriter.print("] ");
    }

    public String put(int messageLevel, Date messageDate, String connectionName, String threadName, long threadId, String message, String exceptionText) {
        String formattedLine = this.formatLogLine(messageLevel, messageDate, connectionName, threadName, threadId, message, exceptionText);
        this.writeFormattedMessage(formattedLine);
        return formattedLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFormattedMessage(String message) {
        PureLogWriter pureLogWriter = this;
        synchronized (pureLogWriter) {
            this.bytesLogged += (long)message.length();
            this.printWriter.print(message);
            this.printWriter.flush();
        }
    }

    long getBytesLogged() {
        return this.bytesLogged;
    }

    public PrintWriter setTarget(PrintWriter printWriter) {
        return this.setTarget(printWriter, 0L);
    }

    public PrintWriter setTarget(File logFile) {
        return this.setTarget(this.createFileOutputStream(logFile), 0L);
    }

    private PrintWriter createFileOutputStream(File logFile) {
        try {
            return new PrintWriter(new FileOutputStream(logFile, true), true);
        }
        catch (FileNotFoundException ex) {
            String s = String.format("Could not open log file \"%s\".", logFile);
            throw new GemFireIOException(s, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter setTarget(PrintWriter printWriter, long targetLength) {
        PureLogWriter pureLogWriter = this;
        synchronized (pureLogWriter) {
            PrintWriter oldPrintWriter = this.printWriter;
            this.bytesLogged = targetLength;
            this.printWriter = printWriter;
            return oldPrintWriter;
        }
    }

    public void close() {
        this.closed = true;
        try {
            if (this.printWriter != null) {
                this.printWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }
}

