/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.source;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.kafka.GeodeConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class GeodeSourceConnectorConfig
extends GeodeConnectorConfig {
    public static final ConfigDef SOURCE_CONFIG_DEF = GeodeSourceConnectorConfig.configurables();
    private final String durableClientId;
    private final String durableClientTimeout;
    private final String cqPrefix;
    private final boolean loadEntireRegion;
    private final int batchSize;
    private final int queueSize;
    private final Map<String, List<String>> regionToTopics;
    private final Collection<String> cqsToRegister = GeodeSourceConnectorConfig.parseRegionToTopics(this.getString("cqsToRegister")).keySet();

    public GeodeSourceConnectorConfig(Map<String, String> connectorProperties) {
        super(SOURCE_CONFIG_DEF, connectorProperties);
        this.regionToTopics = GeodeSourceConnectorConfig.parseRegionToTopics(this.getString("region-to-topics"));
        String durableClientIdPrefix = this.getString("durable-client-id-prefix");
        this.durableClientId = this.isDurable(durableClientIdPrefix) ? durableClientIdPrefix + this.taskId : "";
        this.durableClientTimeout = this.getString("durable-client-timeout");
        this.cqPrefix = this.getString("cq-prefix");
        this.loadEntireRegion = this.getBoolean("load-entire-region");
        this.batchSize = this.getInt("geode-connector-batch-size");
        this.queueSize = this.getInt("geode-connector-queue-size");
    }

    protected static ConfigDef configurables() {
        ConfigDef configDef = GeodeConnectorConfig.configurables();
        configDef.define("cqsToRegister", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Internally created and used parameter, for signalling a task to register CQs on Apache Geode", "Source-Configuration", 1, ConfigDef.Width.LONG, "Continuous Queries (CQ) to register");
        configDef.define("region-to-topics", ConfigDef.Type.STRING, (Object)"[gkcRegion:gkcTopic]", ConfigDef.Importance.HIGH, "A comma separated list of \"one region to many topics\" mappings.  Each mapping is surrounded by brackets.  For example \"[regionName:topicName], \"[anotherRegion: topicName, anotherTopic]\"", "Source-Configuration", 2, ConfigDef.Width.LONG, "Region to topic mapping");
        configDef.define("durable-client-id-prefix", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Prefix string for tasks to append to when registering as a durable client.  If empty string, will not register as a durable client", "Source-Configuration", 3, ConfigDef.Width.MEDIUM, "Durable client ID");
        configDef.define("durable-client-timeout", ConfigDef.Type.STRING, (Object)"60000", ConfigDef.Importance.LOW, "How long in milliseconds to persist values in Geode's durable queue before the queue is invalidated", "Source-Configuration", 4, ConfigDef.Width.MEDIUM, "Durable Client timeout");
        configDef.define("cq-prefix", ConfigDef.Type.STRING, (Object)"cqForGeodeKafka", ConfigDef.Importance.LOW, "Prefix string to identify Connector CQ's on a Geode server", "Source-Configuration", 5, ConfigDef.Width.MEDIUM, "CQ prefix");
        configDef.define("geode-connector-batch-size", ConfigDef.Type.INT, (Object)"50000", ConfigDef.Importance.MEDIUM, "Maximum number of records to return on each poll", "Source-Configuration", 6, ConfigDef.Width.MEDIUM, "Batch size for CQs");
        configDef.define("geode-connector-queue-size", ConfigDef.Type.INT, (Object)"500000", ConfigDef.Importance.MEDIUM, "Maximum number of entries in the connector queue before backing up all Geode CQ listeners sharing the task queue ", "Source-Configuration", 7, ConfigDef.Width.MEDIUM, "Queue size for CQs");
        configDef.define("load-entire-region", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.MEDIUM, "Determines if we should queue up all entries that currently exist in a region.  This allows us to copy existing region data.  Will be replayed whenever a task needs to re-register a CQ", "Source-Configuration", 8, ConfigDef.Width.MEDIUM, "Load entire region");
        return configDef;
    }

    public boolean isDurable() {
        return this.isDurable(this.durableClientId);
    }

    boolean isDurable(String durableClientId) {
        return !durableClientId.equals("");
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    public String getDurableClientId() {
        return this.durableClientId;
    }

    public String getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    public String getCqPrefix() {
        return this.cqPrefix;
    }

    public boolean getLoadEntireRegion() {
        return this.loadEntireRegion;
    }

    public Map<String, List<String>> getRegionToTopics() {
        return this.regionToTopics;
    }

    public Collection<String> getCqsToRegister() {
        return this.cqsToRegister;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }
}

