/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.source;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqStatusListener;
import org.apache.geode.kafka.source.EventBufferSupplier;
import org.apache.geode.kafka.source.GeodeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeodeKafkaSourceListener
implements CqStatusListener {
    private static final Logger logger = LoggerFactory.getLogger(GeodeKafkaSourceListener.class);
    public final String regionName;
    private final EventBufferSupplier eventBufferSupplier;
    private boolean initialResultsLoaded;

    public GeodeKafkaSourceListener(EventBufferSupplier eventBufferSupplier, String regionName) {
        this.regionName = regionName;
        this.eventBufferSupplier = eventBufferSupplier;
        this.initialResultsLoaded = false;
    }

    public void onEvent(CqEvent aCqEvent) {
        while (!this.initialResultsLoaded) {
            Thread.yield();
        }
        try {
            ((BlockingQueue)this.eventBufferSupplier.get()).offer(new GeodeEvent(this.regionName, aCqEvent), 2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.info("GeodeKafkaSource Queue is full, waiting to offer");
            while (true) {
                try {
                    if (!((BlockingQueue)this.eventBufferSupplier.get()).offer(new GeodeEvent(this.regionName, aCqEvent), 2L, TimeUnit.SECONDS)) {
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    logger.info("Thread interrupted while updating buffer", (Throwable)ex);
                }
                logger.info("GeodeKafkaSource Queue is full");
            }
        }
    }

    public void onError(CqEvent aCqEvent) {
    }

    public void onCqDisconnected() {
        logger.info("cq has been disconnected");
    }

    public void onCqConnected() {
    }

    public void signalInitialResultsLoaded() {
        this.initialResultsLoaded = true;
    }
}

