/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.feature.FeatureConfiguration;
import org.osgi.service.feature.FeatureConfigurationBuilder;

class ConfigurationBuilderImpl
implements FeatureConfigurationBuilder {
    private final String p;
    private final String name;
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    ConfigurationBuilderImpl(String pid) {
        this.p = pid;
        this.name = null;
    }

    ConfigurationBuilderImpl(String factoryPid, String name) {
        this.p = factoryPid;
        this.name = name;
    }

    public FeatureConfigurationBuilder addValue(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public FeatureConfigurationBuilder addValues(Map<String, Object> cfg) {
        this.values.putAll(cfg);
        return this;
    }

    public FeatureConfiguration build() {
        if (this.name == null) {
            return new ConfigurationImpl(this.p, null, this.values);
        }
        return new ConfigurationImpl(this.p + "~" + this.name, this.p, this.values);
    }

    private static class ConfigurationImpl
    implements FeatureConfiguration {
        private final String pid;
        private final Optional<String> factoryPid;
        private final Map<String, Object> values;

        private ConfigurationImpl(String pid, String factoryPid, Map<String, Object> values) {
            this.pid = pid;
            this.factoryPid = Optional.ofNullable(factoryPid);
            this.values = Collections.unmodifiableMap(values);
        }

        public String getPid() {
            return this.pid;
        }

        public Optional<String> getFactoryPid() {
            return this.factoryPid;
        }

        public Map<String, Object> getValues() {
            return this.values;
        }

        public int hashCode() {
            return Objects.hash(this.factoryPid, this.pid, this.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConfigurationImpl)) {
                return false;
            }
            ConfigurationImpl other = (ConfigurationImpl)obj;
            return Objects.equals(this.factoryPid, other.factoryPid) && Objects.equals(this.pid, other.pid) && Objects.equals(this.values, other.values);
        }

        public String toString() {
            return "ConfigurationImpl [pid=" + this.pid + "]";
        }
    }
}

