/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBIndex;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBExpressionIndex
extends DBIndex {
    private DBColumnExpr[] columnExpressions;

    public DBExpressionIndex(String name, DBIndex.DBIndexType type, DBColumnExpr ... columnExpressions) {
        super(name, type, null);
        if (columnExpressions == null || columnExpressions.length == 0) {
            throw new InvalidArgumentException("columnExpressions", columnExpressions);
        }
        this.columnExpressions = columnExpressions;
    }

    public DBExpressionIndex(String name, boolean unique, DBColumnExpr ... columnExpressions) {
        this(name, unique ? DBIndex.DBIndexType.UNIQUE : DBIndex.DBIndexType.STANDARD, columnExpressions);
    }

    @Override
    public final DBDatabase getDatabase() {
        return this.columnExpressions[0].getDatabase();
    }

    @Override
    public DBColumnExpr[] getExpressions() {
        return this.columnExpressions;
    }

    @Override
    public boolean contains(DBColumn col) {
        for (DBColumnExpr columnExpression : this.columnExpressions) {
            if (!col.equals(columnExpression.getUpdateColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnPos(DBColumn col) {
        return -1;
    }
}

