/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.dubbo.rpc;

import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.AttachmentsAdapter;

import java.util.Map;

@Deprecated
public interface Filter extends org.apache.dubbo.rpc.Filter {

    Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException;

    @Override
    default org.apache.dubbo.rpc.Result invoke(
            org.apache.dubbo.rpc.Invoker<?> invoker, org.apache.dubbo.rpc.Invocation invocation)
            throws org.apache.dubbo.rpc.RpcException {
        Result invokeResult =
                invoke(new Invoker.CompatibleInvoker<>(invoker), new Invocation.CompatibleInvocation(invocation));

        if (invokeResult instanceof Result.CompatibleResult) {
            return ((Result.CompatibleResult) invokeResult).getDelegate();
        }

        AsyncRpcResult asyncRpcResult = AsyncRpcResult.newDefaultAsyncResult(invocation);
        asyncRpcResult.setValue(invokeResult.getValue());
        asyncRpcResult.setException(invokeResult.getException());
        Map<String, String> attachments = invokeResult.getAttachments();
        if (!(attachments instanceof AttachmentsAdapter.ObjectToStringMap)) {
            asyncRpcResult.setAttachments(attachments);
        }
        asyncRpcResult.setObjectAttachments(invokeResult.getObjectAttachments());

        return asyncRpcResult;
    }
}
