/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.AttributeTypeDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class AttributeTypeDescriptionPage
extends SchemaPage {
    public AttributeTypeDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    @Override
    protected String getTitle() {
        return Messages.getString("AttributeTypeDescriptionPage.AttributeTypes");
    }

    @Override
    protected String getFilterDescription() {
        return Messages.getString("AttributeTypeDescriptionPage.SelectAttributeType");
    }

    @Override
    protected IStructuredContentProvider getContentProvider() {
        return new ATDContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new ATDLabelProvider();
    }

    @Override
    protected ViewerSorter getSorter() {
        return new ATDViewerSorter();
    }

    @Override
    protected ViewerFilter getFilter() {
        return new ATDViewerFilter();
    }

    @Override
    protected SchemaDetailsPage getDetailsPage() {
        return new AttributeTypeDescriptionDetailsPage(this, this.toolkit);
    }

    class ATDContentProvider
    implements IStructuredContentProvider {
        ATDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null) {
                return schema.getAttributeTypeDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ATDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ATDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AttributeType) {
                return SchemaUtils.toString((AbstractSchemaObject)((AbstractSchemaObject)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ATDViewerFilter
    extends ViewerFilter {
        ATDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AttributeType) {
                AttributeType atd = (AttributeType)element;
                boolean matched = Strings.toLowerCase((String)SchemaUtils.toString((AbstractSchemaObject)atd)).indexOf(Strings.toLowerCase((String)AttributeTypeDescriptionPage.this.filterText.getText())) != -1 || Strings.toLowerCase((String)atd.getOid()).indexOf(Strings.toLowerCase((String)AttributeTypeDescriptionPage.this.filterText.getText())) != -1;
                return matched;
            }
            return false;
        }
    }

    class ATDViewerSorter
    extends ViewerSorter {
        ATDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AttributeType) {
                e1 = SchemaUtils.toString((AbstractSchemaObject)((AbstractSchemaObject)e1));
            }
            if (e2 instanceof AttributeType) {
                e2 = SchemaUtils.toString((AbstractSchemaObject)((AbstractSchemaObject)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }
}

