/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.QuickSelect;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.thetacommon.HashOperations;

final class Rebuilder {
    private Rebuilder() {
    }

    static final void quickSelectAndRebuild(MemorySegment seg, int preambleLongs, int lgNomLongs) {
        int lgArrLongs = PreambleUtil.extractLgArrLongs(seg);
        int arrLongs = 1 << lgArrLongs;
        long[] tmpArr = new long[arrLongs];
        int preBytes = preambleLongs << 3;
        MemorySegment.copy(seg, ValueLayout.JAVA_LONG_UNALIGNED, preBytes, tmpArr, 0, arrLongs);
        int pivot = (1 << lgNomLongs) + 1;
        long newThetaLong = QuickSelect.selectExcludingZeros(tmpArr, PreambleUtil.extractCurCount(seg), pivot);
        PreambleUtil.insertThetaLong(seg, newThetaLong);
        long[] tgtArr = new long[arrLongs];
        int newCurCount = HashOperations.hashArrayInsert(tmpArr, tgtArr, lgArrLongs, newThetaLong);
        PreambleUtil.insertCurCount(seg, newCurCount);
        MemorySegment.copy(tgtArr, 0, seg, ValueLayout.JAVA_LONG_UNALIGNED, (long)preBytes, arrLongs);
    }

    static final void moveAndResize(MemorySegment srcSeg, int preambleLongs, int srcLgArrLongs, MemorySegment dstSeg, int dstLgArrLongs, long thetaLong) {
        int preBytes = preambleLongs << 3;
        MemorySegment.copy(srcSeg, 0L, dstSeg, 0L, preBytes);
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, thetaLong);
        MemorySegment.copy(dstHTArr, 0, dstSeg, ValueLayout.JAVA_LONG_UNALIGNED, (long)preBytes, dstHTLen);
        dstSeg.set(ValueLayout.JAVA_BYTE, 4L, (byte)dstLgArrLongs);
    }

    static final void resize(MemorySegment seg, int preambleLongs, int srcLgArrLongs, int tgtLgArrLongs) {
        int preBytes = preambleLongs << 3;
        int srcHTLen = 1 << srcLgArrLongs;
        long[] srcHTArr = new long[srcHTLen];
        MemorySegment.copy(seg, ValueLayout.JAVA_LONG_UNALIGNED, preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << tgtLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, tgtLgArrLongs, PreambleUtil.extractThetaLong(seg));
        MemorySegment.copy(dstHTArr, 0, seg, ValueLayout.JAVA_LONG_UNALIGNED, (long)preBytes, dstHTLen);
        PreambleUtil.insertLgArrLongs(seg, tgtLgArrLongs);
    }

    static final int actLgResizeFactor(long capBytes, int lgArrLongs, int preLongs, int lgRF) {
        int maxHTLongs = Util.floorPowerOf2((int)(capBytes >>> 3) - preLongs);
        int lgFactor = Math.max(Integer.numberOfTrailingZeros(maxHTLongs) - lgArrLongs, 0);
        return lgFactor >= lgRF ? lgRF : lgFactor;
    }
}

