/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.quantilescommon.GenericSortedView;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesAPI;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIteratorAPI;
import org.apache.datasketches.quantilescommon.SketchPartitionLimits;

public interface QuantilesGenericAPI<T>
extends QuantilesAPI,
PartitioningFeature<T>,
SketchPartitionLimits {
    default public double[] getCDF(T[] splitPoints) {
        return this.getCDF(splitPoints, QuantileSearchCriteria.INCLUSIVE);
    }

    public double[] getCDF(T[] var1, QuantileSearchCriteria var2);

    public Class<T> getClassOfT();

    public Comparator<? super T> getComparator();

    public T getMaxItem();

    @Override
    default public int getMaxPartitions() {
        return (int)Math.min(1.0 / this.getNormalizedRankError(true), (double)this.getNumRetained() / 2.0);
    }

    public T getMinItem();

    default public double[] getPMF(T[] splitPoints) {
        return this.getPMF(splitPoints, QuantileSearchCriteria.INCLUSIVE);
    }

    public double[] getPMF(T[] var1, QuantileSearchCriteria var2);

    default public T getQuantile(double rank) {
        return this.getQuantile(rank, QuantileSearchCriteria.INCLUSIVE);
    }

    public T getQuantile(double var1, QuantileSearchCriteria var3);

    public T getQuantileLowerBound(double var1);

    public T getQuantileUpperBound(double var1);

    default public T[] getQuantiles(double[] ranks) {
        return this.getQuantiles(ranks, QuantileSearchCriteria.INCLUSIVE);
    }

    public T[] getQuantiles(double[] var1, QuantileSearchCriteria var2);

    default public double getRank(T quantile) {
        return this.getRank(quantile, QuantileSearchCriteria.INCLUSIVE);
    }

    public double getRank(T var1, QuantileSearchCriteria var2);

    default public double[] getRanks(T[] quantiles) {
        return this.getRanks(quantiles, QuantileSearchCriteria.INCLUSIVE);
    }

    public double[] getRanks(T[] var1, QuantileSearchCriteria var2);

    public GenericSortedView<T> getSortedView();

    public QuantilesGenericSketchIteratorAPI<T> iterator();

    public void update(T var1);
}

