/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.filters.bloomfilter.BitArray;
import org.apache.datasketches.filters.bloomfilter.DirectBitArrayR;

final class DirectBitArray
extends DirectBitArrayR {
    DirectBitArray(int dataLength, long storedNumBitsSet, MemorySegment wseg) {
        super(dataLength, 0L, wseg);
        this.numBitsSet_ = storedNumBitsSet;
    }

    DirectBitArray(int dataLength, MemorySegment wseg) {
        super(dataLength, 0L, wseg);
        this.wseg_.set(ValueLayout.JAVA_INT_UNALIGNED, 0L, this.dataLength_);
        this.setNumBitsSet(0L);
        Util.clear(this.wseg_, 16L, (long)this.dataLength_ * 8L);
    }

    static DirectBitArray initialize(long numBits, MemorySegment wseg) {
        if (numBits <= 0L) {
            throw new SketchesArgumentException("Number of bits must be strictly positive. Found: " + numBits);
        }
        if (numBits > 137438953408L) {
            throw new SketchesArgumentException("Maximum size of a single filter is 137438953408 + bits. Requested: " + numBits);
        }
        int arrayLength = (int)Util.ceilingMultiple2expK(numBits, 6);
        long requiredBytes = (2L + (long)arrayLength) * 8L;
        if (wseg.byteSize() < requiredBytes) {
            throw new SketchesArgumentException("Provided MemorySegment too small for requested array length. Required: " + requiredBytes + ", provided capacity: " + wseg.byteSize());
        }
        return new DirectBitArray(arrayLength, wseg);
    }

    static DirectBitArray writableWrap(MemorySegment seg, boolean isEmpty) {
        long storedNumBitsSet;
        int arrayLength = seg.get(ValueLayout.JAVA_INT_UNALIGNED, 0L);
        long l = storedNumBitsSet = isEmpty ? 0L : seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        if ((long)arrayLength * 64L > 137438953408L) {
            throw new SketchesArgumentException("Possible corruption: Serialized image indicates array beyond maximum filter capacity");
        }
        if (isEmpty) {
            throw new SketchesArgumentException("Cannot wrap an empty filter for writing as there is no backing data array");
        }
        if (storedNumBitsSet != 0L && seg.byteSize() < (long)(arrayLength + 2)) {
            throw new SketchesArgumentException("MemorySegment capacity is insufficient for Bloom Filter. Needs: " + (arrayLength + 2) + " , found: " + seg.byteSize());
        }
        return new DirectBitArray(arrayLength, storedNumBitsSet, seg);
    }

    @Override
    long getNumBitsSet() {
        if (this.isDirty()) {
            this.numBitsSet_ = 0L;
            for (int i = 0; i < this.dataLength_; ++i) {
                this.numBitsSet_ += (long)Long.bitCount(this.getLong(i));
            }
            this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.numBitsSet_);
        }
        return this.numBitsSet_;
    }

    @Override
    protected boolean isDirty() {
        return this.numBitsSet_ == -1L;
    }

    @Override
    boolean getBit(long index) {
        return (this.wseg_.get(ValueLayout.JAVA_BYTE, 16L + (long)((int)index >>> 3)) & 1 << (int)(index & 7L)) != 0;
    }

    @Override
    protected long getLong(int arrayIndex) {
        return this.wseg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L + (long)(arrayIndex << 3));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    void reset() {
        this.setNumBitsSet(0L);
        Util.clear(this.wseg_, 16L, (long)this.dataLength_ * 8L);
    }

    @Override
    void setBit(long index) {
        long segmentOffset = 16L + (long)((int)index >>> 3);
        byte val = this.wseg_.get(ValueLayout.JAVA_BYTE, segmentOffset);
        Util.setBits(this.wseg_, segmentOffset, (byte)(val | 1 << (int)(index & 7L)));
        this.setNumBitsSet(-1L);
    }

    @Override
    boolean getAndSetBit(long index) {
        long segmentOffset = 16L + (long)((int)index >>> 3);
        byte mask = (byte)(1 << (int)(index & 7L));
        byte val = this.wseg_.get(ValueLayout.JAVA_BYTE, segmentOffset);
        if ((val & mask) != 0) {
            return true;
        }
        Util.setBits(this.wseg_, segmentOffset, (byte)(val | mask));
        if (!this.isDirty()) {
            this.setNumBitsSet(this.numBitsSet_ + 1L);
        }
        return false;
    }

    @Override
    void intersect(BitArray other) {
        if (this.getCapacity() != other.getCapacity()) {
            throw new SketchesArgumentException("Cannot intersect bit arrays with unequal lengths");
        }
        this.numBitsSet_ = 0L;
        for (int i = 0; i < this.dataLength_; ++i) {
            long val = this.getLong(i) & other.getLong(i);
            this.numBitsSet_ += (long)Long.bitCount(val);
            this.setLong(i, val);
        }
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.numBitsSet_);
    }

    @Override
    void union(BitArray other) {
        if (this.getCapacity() != other.getCapacity()) {
            throw new SketchesArgumentException("Cannot intersect bit arrays with unequal lengths");
        }
        this.numBitsSet_ = 0L;
        for (int i = 0; i < this.dataLength_; ++i) {
            long val = this.getLong(i) | other.getLong(i);
            this.numBitsSet_ += (long)Long.bitCount(val);
            this.setLong(i, val);
        }
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.numBitsSet_);
    }

    @Override
    void invert() {
        if (this.isDirty()) {
            this.numBitsSet_ = 0L;
            for (int i = 0; i < this.dataLength_; ++i) {
                long val = this.getLong(i) ^ 0xFFFFFFFFFFFFFFFFL;
                this.setLong(i, val);
                this.numBitsSet_ += (long)Long.bitCount(val);
            }
        } else {
            for (int i = 0; i < this.dataLength_; ++i) {
                this.setLong(i, this.getLong(i) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.numBitsSet_ = this.getCapacity() - this.numBitsSet_;
        }
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.numBitsSet_);
    }

    @Override
    protected void setLong(int arrayIndex, long value) {
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L + (long)(arrayIndex << 3), value);
    }

    private void setNumBitsSet(long numBitsSet) {
        this.numBitsSet_ = numBitsSet;
        this.wseg_.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, numBitsSet);
    }
}

