/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.FloatsSketchSortedView;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.LinearRanksAndQuantiles;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.req.ReqSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CrossCheckQuantilesTest {
    private final ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private final Comparator<String> comparator = Comparator.naturalOrder();
    private static final int k = 32;
    final float[][] svFValues = new float[][]{{10.0f}, {10.0f, 10.0f}, {10.0f, 20.0f, 30.0f, 40.0f}, {10.0f, 20.0f, 20.0f, 30.0f, 30.0f, 30.0f, 40.0f, 50.0f}, {10.0f, 10.0f, 20.0f, 20.0f, 30.0f, 30.0f, 40.0f, 40.0f}};
    final double[][] svDValues = new double[][]{{10.0}, {10.0, 10.0}, {10.0, 20.0, 30.0, 40.0}, {10.0, 20.0, 20.0, 30.0, 30.0, 30.0, 40.0, 50.0}, {10.0, 10.0, 20.0, 20.0, 30.0, 30.0, 40.0, 40.0}};
    final String[][] svIValues = new String[][]{{"10"}, {"10", "10"}, {"10", "20", "30", "40"}, {"10", "20", "20", "30", "30", "30", "40", "50"}, {"10", "10", "20", "20", "30", "30", "40", "40"}};
    final long[][] svWeights = new long[][]{{1L}, {1L, 1L}, {2L, 2L, 2L, 2L}, {2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L}, {2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L}};
    final float[] svMaxFValues = new float[]{10.0f, 10.0f, 40.0f, 50.0f, 40.0f};
    final float[] svMinFValues = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
    final double[] svMaxDValues = new double[]{10.0, 10.0, 40.0, 50.0, 40.0};
    final double[] svMinDValues = new double[]{10.0, 10.0, 10.0, 10.0, 10.0};
    final String[] svMaxIValues = new String[]{"10", "10", "40", "50", "40"};
    final String[] svMinIValues = new String[]{"10", "10", "10", "10", "10"};
    int numSets;
    long[][] svCumWeights;
    long[] totalN;
    float[][] skFStreamValues;
    double[][] skDStreamValues;
    String[][] skIStreamValues;
    ReqSketch reqFloatsSk = null;
    KllFloatsSketch kllFloatsSk = null;
    KllDoublesSketch kllDoublesSk = null;
    UpdatableQuantilesDoublesSketch classicDoublesSk = null;
    KllItemsSketch<String> kllItemsSk = null;
    QuantilesItemsSketch<String> itemsSk = null;
    FloatsSketchSortedView floatsSV = null;
    DoublesSketchSortedView doublesSV = null;
    ItemsSketchSortedView<String> classicItemsSV = null;
    ItemsSketchSortedView<String> kllItemsSV = null;
    private static final boolean enablePrinting = false;

    @Test
    public void runTests() throws Exception {
        this.buildDataSets();
        for (int set = 0; set < this.numSets; ++set) {
            this.buildSVs(set);
            this.buildSketches(set);
            CrossCheckQuantilesTest.println("");
            CrossCheckQuantilesTest.println("TEST getRank, Set " + set + ", all Criteria, across all sketches and their Sorted Views:");
            this.checkGetRank(set, QuantileSearchCriteria.INCLUSIVE);
            this.checkGetRank(set, QuantileSearchCriteria.EXCLUSIVE);
            CrossCheckQuantilesTest.println("");
            CrossCheckQuantilesTest.println("TEST getQuantile, Set " + set + ", all Criteria, across all sketches and their Sorted Views:");
            this.checkGetQuantile(set, QuantileSearchCriteria.INCLUSIVE);
            this.checkGetQuantile(set, QuantileSearchCriteria.EXCLUSIVE);
        }
    }

    private void checkGetRank(int set, QuantileSearchCriteria crit) {
        int maxItemValue;
        double testRank;
        double trueRank;
        CrossCheckQuantilesTest.println(Util.LS + "FLOATS getRank Test SV vs Sk");
        float maxFloatvalue = this.getMaxFloatValue(set);
        for (float v = 5.0f; v <= maxFloatvalue + 5.0f; v += 5.0f) {
            trueRank = LinearRanksAndQuantiles.getTrueFloatRank(this.svCumWeights[set], this.svFValues[set], v, crit);
            testRank = this.floatsSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.reqFloatsSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllFloatsSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            CrossCheckQuantilesTest.println("Floats  set: " + set + ", value: " + v + ", rank: " + trueRank + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println(Util.LS + "DOUBLES getRank Test SV vs Sk");
        double maxDoubleValue = this.getMaxDoubleValue(set);
        for (double v = 5.0; v <= maxDoubleValue + 5.0; v += 5.0) {
            trueRank = LinearRanksAndQuantiles.getTrueDoubleRank(this.svCumWeights[set], this.svDValues[set], v, crit);
            testRank = this.doublesSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllDoublesSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.classicDoublesSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            CrossCheckQuantilesTest.println("Doubles set: " + set + ", value: " + v + ", rank: " + trueRank + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println(Util.LS + "ITEMS getRank Test SV vs Sk");
        try {
            maxItemValue = Integer.parseInt(this.getMaxItemValue(set));
        }
        catch (NumberFormatException e) {
            throw new SketchesArgumentException(e.toString());
        }
        for (int v = 5; v <= maxItemValue + 5; v += 5) {
            String s = Util.longToFixedLengthString((long)v, (int)2);
            trueRank = LinearRanksAndQuantiles.getTrueItemRank(this.svCumWeights[set], this.svIValues[set], s, crit, this.comparator);
            testRank = this.kllItemsSV.getRank((Object)s, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllItemsSk.getRank((Object)s, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.classicItemsSV.getRank((Object)s, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.itemsSk.getRank((Object)s, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            CrossCheckQuantilesTest.println("Items set: " + set + ", value: " + s + ", rank: " + trueRank + ", crit: " + crit.toString());
        }
    }

    private void checkGetQuantile(int set, QuantileSearchCriteria crit) {
        int twoN = (int)this.totalN[set] * 2;
        double dTwoN = twoN;
        CrossCheckQuantilesTest.println(Util.LS + "FLOATS getQuantile Test SV vs Sk");
        for (int i = 0; i <= twoN; ++i) {
            double normRank = (double)i / dTwoN;
            float trueFQ = LinearRanksAndQuantiles.getTrueFloatQuantile(this.svCumWeights[set], this.svFValues[set], normRank, crit);
            float testFQ = this.floatsSV.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            testFQ = this.reqFloatsSk.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            testFQ = this.kllFloatsSk.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            CrossCheckQuantilesTest.println("Floats  set: " + set + ", rank: " + normRank + ", Q: " + trueFQ + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println(Util.LS + "DOUBLES getQuantile Test SV vs Sk");
        for (int i = 0; i <= twoN; ++i) {
            double normRank = (double)i / dTwoN;
            double trueDQ = LinearRanksAndQuantiles.getTrueDoubleQuantile(this.svCumWeights[set], this.svDValues[set], normRank, crit);
            double testDQ = this.doublesSV.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            testDQ = this.kllDoublesSk.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            testDQ = this.classicDoublesSk.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            CrossCheckQuantilesTest.println("Doubles set: " + set + ", rank: " + normRank + ", Q: " + trueDQ + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println(Util.LS + "ITEMS getQuantile Test SV vs Sk");
        for (int i = 0; i <= twoN; ++i) {
            double normRank = (double)i / dTwoN;
            String trueIQ = LinearRanksAndQuantiles.getTrueItemQuantile(this.svCumWeights[set], this.svIValues[set], normRank, crit);
            String testIQ = (String)this.kllItemsSV.getQuantile(normRank, crit);
            Assert.assertEquals((String)testIQ, (String)trueIQ);
            testIQ = (String)this.kllItemsSk.getQuantile(normRank, crit);
            Assert.assertEquals((String)testIQ, (String)trueIQ);
            testIQ = (String)this.classicItemsSV.getQuantile(normRank, crit);
            Assert.assertEquals((String)testIQ, (String)trueIQ);
            testIQ = (String)this.itemsSk.getQuantile(normRank, crit);
            Assert.assertEquals((String)testIQ, (String)trueIQ);
            CrossCheckQuantilesTest.println("Items set: " + set + ", rank: " + normRank + ", Q: " + trueIQ + ", crit: " + crit.toString());
        }
    }

    private double getMaxDoubleValue(int set) {
        int streamLen = this.skDStreamValues[set].length;
        return this.skDStreamValues[set][streamLen - 1];
    }

    private float getMaxFloatValue(int set) {
        int streamLen = this.skFStreamValues[set].length;
        return this.skFStreamValues[set][streamLen - 1];
    }

    private String getMaxItemValue(int set) {
        int streamLen = this.skIStreamValues[set].length;
        return this.skIStreamValues[set][streamLen - 1];
    }

    private void buildSketches(int set) {
        this.reqFloatsSk = ReqSketch.builder().setK(32).build();
        this.kllFloatsSk = KllFloatsSketch.newHeapInstance((int)32);
        this.kllDoublesSk = KllDoublesSketch.newHeapInstance((int)32);
        this.classicDoublesSk = QuantilesDoublesSketch.builder().setK(32).build();
        this.kllItemsSk = KllItemsSketch.newHeapInstance((int)32, this.comparator, (ArrayOfItemsSerDe)this.serDe);
        this.itemsSk = QuantilesItemsSketch.getInstance(String.class, (int)32, this.comparator);
        int count = this.skFStreamValues[set].length;
        for (int i = 0; i < count; ++i) {
            this.reqFloatsSk.update(this.skFStreamValues[set][i]);
            this.kllFloatsSk.update(this.skFStreamValues[set][i]);
            this.kllDoublesSk.update(this.skDStreamValues[set][i]);
            this.classicDoublesSk.update(this.skDStreamValues[set][i]);
            this.kllItemsSk.update((Object)this.skIStreamValues[set][i]);
            this.itemsSk.update((Object)this.skIStreamValues[set][i]);
        }
    }

    private void buildSVs(int set) throws Exception {
        this.floatsSV = new FloatsSketchSortedView(this.svFValues[set], this.svCumWeights[set], this.totalN[set], this.svMaxFValues[set], this.svMinFValues[set]);
        this.doublesSV = new DoublesSketchSortedView(this.svDValues[set], this.svCumWeights[set], this.totalN[set], this.svMaxDValues[set], this.svMinDValues[set]);
        String svImax = this.svIValues[set][this.svIValues[set].length - 1];
        String svImin = this.svIValues[set][0];
        this.kllItemsSV = new ItemsSketchSortedView(this.svIValues[set], this.svCumWeights[set], this.totalN[set], this.comparator, (Object)svImax, (Object)svImin, String.class, 0.01, this.svCumWeights[set].length);
        this.classicItemsSV = new ItemsSketchSortedView(this.svIValues[set], this.svCumWeights[set], this.totalN[set], this.comparator, (Object)svImax, (Object)svImin, String.class, 0.01, this.svCumWeights[set].length);
    }

    private void buildDataSets() {
        this.numSets = this.svWeights.length;
        this.svCumWeights = new long[this.numSets][];
        this.totalN = new long[this.numSets];
        this.skFStreamValues = new float[this.numSets][];
        this.skDStreamValues = new double[this.numSets][];
        this.skIStreamValues = new String[this.numSets][];
        for (int i = 0; i < this.numSets; ++i) {
            this.svCumWeights[i] = CrossCheckQuantilesTest.convertToCumWeights(this.svWeights[i]);
            int len = this.svCumWeights[i].length;
            int totalCount = (int)this.svCumWeights[i][len - 1];
            this.totalN[i] = totalCount;
            this.skFStreamValues[i] = CrossCheckQuantilesTest.convertToFloatStream(this.svFValues[i], this.svWeights[i], totalCount);
            this.skDStreamValues[i] = CrossCheckQuantilesTest.convertToDoubleStream(this.svDValues[i], this.svWeights[i], totalCount);
            this.skIStreamValues[i] = CrossCheckQuantilesTest.convertToItemStream(this.svIValues[i], this.svWeights[i], totalCount);
        }
        CrossCheckQuantilesTest.println("");
    }

    private static float[] convertToFloatStream(float[] svFValueArr, long[] svWeightsArr, int totalCount) {
        float[] out = new float[totalCount];
        int len = svWeightsArr.length;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            float f = svFValueArr[j];
            int wt = (int)svWeightsArr[j];
            for (int w = 0; w < wt; ++w) {
                out[i++] = f;
            }
        }
        return out;
    }

    private static double[] convertToDoubleStream(double[] svDValueArr, long[] svWeightsArr, int totalCount) {
        double[] out = new double[totalCount];
        int len = svWeightsArr.length;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            double d = svDValueArr[j];
            int wt = (int)svWeightsArr[j];
            for (int w = 0; w < wt; ++w) {
                out[i++] = d;
            }
        }
        return out;
    }

    private static String[] convertToItemStream(String[] svIValueArr, long[] svWeightsArr, int totalCount) {
        String[] out = new String[totalCount];
        int len = svWeightsArr.length;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            String s = svIValueArr[j];
            int wt = (int)svWeightsArr[j];
            for (int w = 0; w < wt; ++w) {
                out[i++] = s;
            }
        }
        return out;
    }

    private static long[] convertToCumWeights(long[] weights) {
        int len = weights.length;
        long[] out = new long[len];
        out[0] = weights[0];
        for (int i = 1; i < len; ++i) {
            out[i] = weights[i] + out[i - 1];
        }
        return out;
    }

    private static final void println(Object o) {
    }
}

