/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Random;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.annotations.Test;

public class AccuracyTest {
    static Random rand = new Random(1L);

    @Test
    public void baseTest() {
        int n = 0x100000;
        int k = 32;
        double[] seqArr = new double[n];
        for (int i = 1; i <= n; ++i) {
            seqArr[i - 1] = i;
        }
        double[] randArr = (double[])seqArr.clone();
        AccuracyTest.shuffle(randArr);
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().setK(k).build();
        for (int i = 0; i < n; ++i) {
            sketch.update(randArr[i]);
        }
        double[] ranks = sketch.getCDF(seqArr);
        double maxDelta = 0.0;
        for (int i = 0; i < n; ++i) {
            double actRank = (double)i / (double)n;
            double estRank = ranks[i];
            double delta = actRank - estRank;
            maxDelta = Math.max(maxDelta, delta);
        }
        AccuracyTest.println("Max delta: " + maxDelta);
        AccuracyTest.println(sketch.toString());
    }

    public static void shuffle(double[] arr) {
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            int j = i + rand.nextInt(n - i);
            AccuracyTest.swap(arr, i, j);
        }
    }

    public static void swap(double[] arr, int i, int j) {
        double t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public void getEpsilon() {
        for (int lgK = 4; lgK < 15; ++lgK) {
            int k = 1 << lgK;
            double eps = ClassicUtil.getNormalizedRankError((int)k, (boolean)false);
            AccuracyTest.println(k + "\t" + eps);
        }
    }

    @Test
    public void printlnTest() {
        AccuracyTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

