/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common.positional;

import org.apache.datasketches.common.positional.PositionInvariantsException;
import org.apache.datasketches.common.positional.Positional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PositionalTest {
    @Test
    public void checkInvariants() {
        Positional posit = Positional.getInstance((long)100L);
        posit.setStartPositionEnd(40L, 45L, 50L);
        posit.setStartPositionEnd(0L, 0L, 100L);
        try {
            posit.setStartPositionEnd(0L, 0L, 101L);
            Assert.fail();
        }
        catch (PositionInvariantsException positionInvariantsException) {
            // empty catch block
        }
        try {
            posit.setPosition(101L);
            Assert.fail();
        }
        catch (PositionInvariantsException positionInvariantsException) {
            // empty catch block
        }
        try {
            posit.setStartPositionEnd(50L, 45L, 40L);
            Assert.fail();
        }
        catch (PositionInvariantsException positionInvariantsException) {
            // empty catch block
        }
    }

    @Test
    public void checkGetSets() {
        Positional posit = Positional.getInstance((long)100L);
        posit.setStartPositionEnd(40L, 45L, 50L);
        Assert.assertEquals((long)posit.getStart(), (long)40L);
        Assert.assertEquals((long)posit.getPosition(), (long)45L);
        Assert.assertEquals((long)posit.getEnd(), (long)50L);
        Assert.assertEquals((long)posit.getRemaining(), (long)5L);
        Assert.assertTrue((boolean)posit.hasRemaining());
        posit.resetPosition();
        Assert.assertEquals((long)posit.getPosition(), (long)40L);
        posit.setPosition(45L);
        Assert.assertEquals((long)posit.getPosition(), (long)45L);
        posit.incrementPosition(1L);
        Assert.assertEquals((long)posit.getPosition(), (long)46L);
    }
}

