/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.web;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.fediz.core.SecurityTokenThreadLocal;
import org.apache.cxf.ws.security.trust.delegation.DelegationCallback;
import org.apache.wss4j.common.util.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ThreadLocalCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalCallbackHandler.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof DelegationCallback) {
                DelegationCallback callback = (DelegationCallback)callbacks[i];
                Element token = SecurityTokenThreadLocal.getToken();
                if (token == null) {
                    LOG.error("Security token not cached in thread local storage. Check configuration");
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("******************** TOKEN ********************");
                    LOG.debug(DOM2Writer.nodeToString((Node)token));
                    LOG.debug("****************** END TOKEN *******************");
                }
                callback.setToken(token);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

