/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.primitive.ObjectSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AssertionValidationSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSubjectConfirmationValidator
implements SubjectConfirmationValidator {
    private Logger log = LoggerFactory.getLogger(AbstractSubjectConfirmationValidator.class);

    @Nonnull
    public ValidationResult validate(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        boolean addressRequired = this.isAddressRequired(context);
        boolean inResponseToRequired = this.isInResponseToRequired(context);
        boolean recipientRequired = this.isRecipientRequired(context);
        boolean notOnOrAfterRequired = this.isNotOnOrAfterRequired(context);
        boolean notBeforeRequired = this.isNotBeforeRequired(context);
        if (confirmation.getSubjectConfirmationData() != null) {
            ValidationResult result = this.validateNotBefore(confirmation, assertion, context, notBeforeRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateNotOnOrAfter(confirmation, assertion, context, notOnOrAfterRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateRecipient(confirmation, assertion, context, recipientRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateAddress(confirmation, assertion, context, addressRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateInResponseTo(confirmation, assertion, context, inResponseToRequired);
            if (result != ValidationResult.VALID) {
                return result;
            }
        } else if (inResponseToRequired || recipientRequired || notOnOrAfterRequired || notBeforeRequired || addressRequired) {
            this.log.warn("SubjectConfirmationData was null, and one of more data elements were required");
            context.setValidationFailureMessage("SubjectConfirmationData was null and one or more data elements were required");
            return ValidationResult.INVALID;
        }
        return this.doValidate(confirmation, assertion, context);
    }

    protected boolean isAddressRequired(ValidationContext context) {
        return (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.AddressRequired"), Boolean.FALSE});
    }

    protected boolean isRecipientRequired(ValidationContext context) {
        return (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.RecipientRequired"), Boolean.FALSE});
    }

    protected boolean isNotBeforeRequired(ValidationContext context) {
        return (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.NotBeforeRequired"), Boolean.FALSE});
    }

    protected boolean isNotOnOrAfterRequired(ValidationContext context) {
        return (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.NoOnOrAfterRequired"), Boolean.FALSE});
    }

    protected boolean isInResponseToRequired(ValidationContext context) {
        return (Boolean)ObjectSupport.firstNonNull((Object[])new Boolean[]{(Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.InResponseToRequired"), Boolean.FALSE});
    }

    protected ValidationResult validateInResponseTo(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        String validInResponseTo;
        String inResponseTo = StringSupport.trimOrNull((String)confirmation.getSubjectConfirmationData().getInResponseTo());
        if (inResponseTo == null) {
            if (required) {
                this.log.warn("SubjectConfirmationData/@InResponseTo was missing and was required");
                context.setValidationFailureMessage("SubjectConfirmationData/@InResponseTo was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        this.log.debug("Evaluating SubjectConfirmationData@InResponseTo of: {}", (Object)inResponseTo);
        try {
            validInResponseTo = (String)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidInResponseTo");
        }
        catch (ClassCastException e) {
            this.log.warn("The value of the static validation parameter '{}' was not java.lang.String", (Object)"saml2.SubjectConfirmation.ValidInResponseTo");
            context.setValidationFailureMessage("Unable to determine valid subject confirmation InResponseTo");
            return ValidationResult.INDETERMINATE;
        }
        if (validInResponseTo == null) {
            this.log.warn("Valid InResponseTo was not available from the validation context, unable to evaluate SubjectConfirmationData@InResponseTo");
            context.setValidationFailureMessage("Unable to determine valid subject confirmation InResponseTo");
            return ValidationResult.INDETERMINATE;
        }
        if (Objects.equals(inResponseTo, validInResponseTo)) {
            this.log.debug("Matched valid InResponseTo: {}", (Object)inResponseTo);
            return ValidationResult.VALID;
        }
        this.log.debug("Failed to match SubjectConfirmationData@InResponse to the valid value: {}", (Object)validInResponseTo);
        context.setValidationFailureMessage(String.format("Subject confirmation InResponseTo for assertion '%s' did not match the valid value", assertion.getID()));
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateNotBefore(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Instant notBefore = confirmation.getSubjectConfirmationData().getNotBefore();
        if (notBefore == null) {
            if (required) {
                this.log.warn("SubjectConfirmationData/@NotBefore was missing and was required");
                context.setValidationFailureMessage("SubjectConfirmationData/@NotBefore was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        Instant skewedNow = Instant.now().plus(SAML20AssertionValidator.getClockSkew((ValidationContext)context));
        this.log.debug("Evaluating SubjectConfirmationData NotBefore '{}' against 'skewed now' time '{}'", (Object)notBefore, (Object)skewedNow);
        if (notBefore != null && notBefore.isAfter(skewedNow)) {
            context.setValidationFailureMessage(String.format("Subject confirmation, in assertion '%s', with NotBefore condition of '%s' is not yet valid", assertion.getID(), notBefore));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateNotOnOrAfter(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Instant notOnOrAfter = confirmation.getSubjectConfirmationData().getNotOnOrAfter();
        if (notOnOrAfter == null) {
            if (required) {
                this.log.warn("SubjectConfirmationData/@NotOnOrAfter was missing and was required");
                context.setValidationFailureMessage("SubjectConfirmationData/@NotOnOrAfter was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        Instant skewedNow = Instant.now().minus(SAML20AssertionValidator.getClockSkew((ValidationContext)context));
        this.log.debug("Evaluating SubjectConfirmationData NotOnOrAfter '{}' against 'skewed now' time '{}'", (Object)notOnOrAfter, (Object)skewedNow);
        if (notOnOrAfter != null && notOnOrAfter.isBefore(skewedNow)) {
            context.setValidationFailureMessage(String.format("Subject confirmation, in assertion '%s', with NotOnOrAfter condition of '%s' is no longer valid", assertion.getID(), notOnOrAfter));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected ValidationResult validateRecipient(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Set validRecipients;
        String recipient = StringSupport.trimOrNull((String)confirmation.getSubjectConfirmationData().getRecipient());
        if (recipient == null) {
            if (required) {
                this.log.warn("SubjectConfirmationData/@Recipient was missing and was required");
                context.setValidationFailureMessage("SubjectConfirmationData/@Recipient was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        this.log.debug("Evaluating SubjectConfirmationData@Recipient of : {}", (Object)recipient);
        try {
            validRecipients = (Set)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidRecipients");
        }
        catch (ClassCastException e) {
            this.log.warn("The value of the static validation parameter '{}' was not java.util.Set<String>", (Object)"saml2.SubjectConfirmation.ValidRecipients");
            context.setValidationFailureMessage("Unable to determine list of valid subject confirmation recipient endpoints");
            return ValidationResult.INDETERMINATE;
        }
        if (validRecipients == null || validRecipients.isEmpty()) {
            this.log.warn("Set of valid recipient URI's was not available from the validation context, unable to evaluate SubjectConfirmationData@Recipient");
            context.setValidationFailureMessage("Unable to determine list of valid subject confirmation recipient endpoints");
            return ValidationResult.INDETERMINATE;
        }
        if (validRecipients.contains(recipient)) {
            this.log.debug("Matched valid recipient: {}", (Object)recipient);
            return ValidationResult.VALID;
        }
        this.log.debug("Failed to match SubjectConfirmationData@Recipient to any supplied valid recipients: {}", (Object)validRecipients);
        context.setValidationFailureMessage(String.format("Subject confirmation recipient for assertion '%s' did not match any valid recipients", assertion.getID()));
        return ValidationResult.INVALID;
    }

    @Nonnull
    protected ValidationResult validateAddress(@Nonnull SubjectConfirmation confirmation, @Nonnull Assertion assertion, @Nonnull ValidationContext context, boolean required) throws AssertionValidationException {
        Boolean checkAddress = (Boolean)context.getStaticParameters().get("saml2.SubjectConfirmation.CheckAddress");
        if (checkAddress != null && !checkAddress.booleanValue()) {
            this.log.debug("SubjectConfirmationData/@Address check is disabled, skipping");
            return ValidationResult.VALID;
        }
        String address = StringSupport.trimOrNull((String)confirmation.getSubjectConfirmationData().getAddress());
        if (address == null) {
            if (required) {
                this.log.warn("SubjectConfirmationData/@Address was missing and was required");
                context.setValidationFailureMessage("SubjectConfirmationData/@Address was missing and was required");
                return ValidationResult.INVALID;
            }
            return ValidationResult.VALID;
        }
        return AssertionValidationSupport.checkAddress(context, address, "saml2.SubjectConfirmation.ValidAddresses", assertion, "SubjectConfirmationData/@Address");
    }

    @Nonnull
    protected abstract ValidationResult doValidate(@Nonnull SubjectConfirmation var1, @Nonnull Assertion var2, @Nonnull ValidationContext var3) throws AssertionValidationException;
}

