/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;

final class NullHasher
implements Hasher {
    static final NullHasher INSTANCE = new NullHasher();
    private static final IndexExtractor INDEX_EXTRACTOR = new IndexExtractor(){

        public int[] asIndexArray() {
            return new int[0];
        }

        public boolean processIndices(IntPredicate consumer) {
            Objects.requireNonNull(consumer, "consumer");
            return true;
        }
    };

    private NullHasher() {
    }

    public IndexExtractor indices(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return INDEX_EXTRACTOR;
    }
}

