/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformstatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationplatformstatus.traits.ContainerBuilder;
import org.apache.camel.v1.integrationplatformstatus.traits.container.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"allowPrivilegeEscalation", "auto", "capabilitiesAdd", "capabilitiesDrop", "configuration", "enabled", "expose", "image", "imagePullPolicy", "limitCPU", "limitMemory", "name", "port", "portName", "requestCPU", "requestMemory", "runAsNonRoot", "runAsUser", "seccompProfileType", "servicePort", "servicePortName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Container
implements Editable<ContainerBuilder>,
KubernetesResource {
    @JsonProperty(value="allowPrivilegeEscalation")
    @JsonPropertyDescription(value="Security Context AllowPrivilegeEscalation configuration (default false).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean allowPrivilegeEscalation;
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="To automatically enable the trait")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="capabilitiesAdd")
    @JsonPropertyDescription(value="Security Context Capabilities Add configuration (default none).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> capabilitiesAdd;
    @JsonProperty(value="capabilitiesDrop")
    @JsonPropertyDescription(value="Security Context Capabilities Drop configuration (default ALL).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> capabilitiesDrop;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters.\nDeprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="expose")
    @JsonPropertyDescription(value="Can be used to enable/disable exposure via kubernetes Service.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean expose;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="The main container image to use for the Integration. When using this parameter the operator will create a synthetic IntegrationKit which\nwon't be able to execute traits requiring CamelCatalog. If the container image you're using is coming from an IntegrationKit, use instead\nIntegration `.spec.integrationKit` parameter. If you're moving the Integration across environments, you will also need to create an \"external\" IntegrationKit.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="imagePullPolicy")
    @JsonPropertyDescription(value="The pull policy: Always|Never|IfNotPresent")
    @JsonSetter(nulls=Nulls.SKIP)
    private ImagePullPolicy imagePullPolicy;
    @JsonProperty(value="limitCPU")
    @JsonPropertyDescription(value="The maximum amount of CPU to be provided (default 500 millicores).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitCPU;
    @JsonProperty(value="limitMemory")
    @JsonPropertyDescription(value="The maximum amount of memory to be provided (default 512 Mi).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitMemory;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The main container name. It's named `integration` by default.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="To configure a different port exposed by the container (default `8080`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long port;
    @JsonProperty(value="portName")
    @JsonPropertyDescription(value="To configure a different port name for the port exposed by the container. It defaults to `http` only when the `expose` parameter is true.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String portName;
    @JsonProperty(value="requestCPU")
    @JsonPropertyDescription(value="The minimum amount of CPU required (default 125 millicores).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestCPU;
    @JsonProperty(value="requestMemory")
    @JsonPropertyDescription(value="The minimum amount of memory required (default 128 Mi).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestMemory;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Security Context RunAsNonRoot configuration (default false).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean runAsNonRoot;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="Security Context RunAsUser configuration (default none): this value is automatically retrieved in Openshift clusters when not explicitly set.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsUser;
    @JsonProperty(value="seccompProfileType")
    @JsonPropertyDescription(value="Security Context SeccompProfileType configuration (default RuntimeDefault).")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeccompProfileType seccompProfileType;
    @JsonProperty(value="servicePort")
    @JsonPropertyDescription(value="To configure under which service port the container port is to be exposed (default `80`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long servicePort;
    @JsonProperty(value="servicePortName")
    @JsonPropertyDescription(value="To configure under which service port name the container port is to be exposed (default `http`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String servicePortName;

    public ContainerBuilder edit() {
        return new ContainerBuilder(this);
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public List<String> getCapabilitiesAdd() {
        return this.capabilitiesAdd;
    }

    public void setCapabilitiesAdd(List<String> capabilitiesAdd) {
        this.capabilitiesAdd = capabilitiesAdd;
    }

    public List<String> getCapabilitiesDrop() {
        return this.capabilitiesDrop;
    }

    public void setCapabilitiesDrop(List<String> capabilitiesDrop) {
        this.capabilitiesDrop = capabilitiesDrop;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public void setExpose(Boolean expose) {
        this.expose = expose;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public void setLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public void setRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public SeccompProfileType getSeccompProfileType() {
        return this.seccompProfileType;
    }

    public void setSeccompProfileType(SeccompProfileType seccompProfileType) {
        this.seccompProfileType = seccompProfileType;
    }

    public Long getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(Long servicePort) {
        this.servicePort = servicePort;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public String toString() {
        return "Container(allowPrivilegeEscalation=" + this.getAllowPrivilegeEscalation() + ", auto=" + this.getAuto() + ", capabilitiesAdd=" + this.getCapabilitiesAdd() + ", capabilitiesDrop=" + this.getCapabilitiesDrop() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", expose=" + this.getExpose() + ", image=" + this.getImage() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", limitCPU=" + this.getLimitCPU() + ", limitMemory=" + this.getLimitMemory() + ", name=" + this.getName() + ", port=" + this.getPort() + ", portName=" + this.getPortName() + ", requestCPU=" + this.getRequestCPU() + ", requestMemory=" + this.getRequestMemory() + ", runAsNonRoot=" + this.getRunAsNonRoot() + ", runAsUser=" + this.getRunAsUser() + ", seccompProfileType=" + this.getSeccompProfileType() + ", servicePort=" + this.getServicePort() + ", servicePortName=" + this.getServicePortName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowPrivilegeEscalation = this.getAllowPrivilegeEscalation();
        Boolean other$allowPrivilegeEscalation = other.getAllowPrivilegeEscalation();
        if (this$allowPrivilegeEscalation == null ? other$allowPrivilegeEscalation != null : !((Object)this$allowPrivilegeEscalation).equals(other$allowPrivilegeEscalation)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$expose = this.getExpose();
        Boolean other$expose = other.getExpose();
        if (this$expose == null ? other$expose != null : !((Object)this$expose).equals(other$expose)) {
            return false;
        }
        Long this$port = this.getPort();
        Long other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$runAsNonRoot = this.getRunAsNonRoot();
        Boolean other$runAsNonRoot = other.getRunAsNonRoot();
        if (this$runAsNonRoot == null ? other$runAsNonRoot != null : !((Object)this$runAsNonRoot).equals(other$runAsNonRoot)) {
            return false;
        }
        Long this$runAsUser = this.getRunAsUser();
        Long other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !((Object)this$runAsUser).equals(other$runAsUser)) {
            return false;
        }
        Long this$servicePort = this.getServicePort();
        Long other$servicePort = other.getServicePort();
        if (this$servicePort == null ? other$servicePort != null : !((Object)this$servicePort).equals(other$servicePort)) {
            return false;
        }
        List<String> this$capabilitiesAdd = this.getCapabilitiesAdd();
        List<String> other$capabilitiesAdd = other.getCapabilitiesAdd();
        if (this$capabilitiesAdd == null ? other$capabilitiesAdd != null : !((Object)this$capabilitiesAdd).equals(other$capabilitiesAdd)) {
            return false;
        }
        List<String> this$capabilitiesDrop = this.getCapabilitiesDrop();
        List<String> other$capabilitiesDrop = other.getCapabilitiesDrop();
        if (this$capabilitiesDrop == null ? other$capabilitiesDrop != null : !((Object)this$capabilitiesDrop).equals(other$capabilitiesDrop)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        ImagePullPolicy this$imagePullPolicy = this.getImagePullPolicy();
        ImagePullPolicy other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !((Object)((Object)this$imagePullPolicy)).equals((Object)other$imagePullPolicy)) {
            return false;
        }
        String this$limitCPU = this.getLimitCPU();
        String other$limitCPU = other.getLimitCPU();
        if (this$limitCPU == null ? other$limitCPU != null : !this$limitCPU.equals(other$limitCPU)) {
            return false;
        }
        String this$limitMemory = this.getLimitMemory();
        String other$limitMemory = other.getLimitMemory();
        if (this$limitMemory == null ? other$limitMemory != null : !this$limitMemory.equals(other$limitMemory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$portName = this.getPortName();
        String other$portName = other.getPortName();
        if (this$portName == null ? other$portName != null : !this$portName.equals(other$portName)) {
            return false;
        }
        String this$requestCPU = this.getRequestCPU();
        String other$requestCPU = other.getRequestCPU();
        if (this$requestCPU == null ? other$requestCPU != null : !this$requestCPU.equals(other$requestCPU)) {
            return false;
        }
        String this$requestMemory = this.getRequestMemory();
        String other$requestMemory = other.getRequestMemory();
        if (this$requestMemory == null ? other$requestMemory != null : !this$requestMemory.equals(other$requestMemory)) {
            return false;
        }
        SeccompProfileType this$seccompProfileType = this.getSeccompProfileType();
        SeccompProfileType other$seccompProfileType = other.getSeccompProfileType();
        if (this$seccompProfileType == null ? other$seccompProfileType != null : !((Object)((Object)this$seccompProfileType)).equals((Object)other$seccompProfileType)) {
            return false;
        }
        String this$servicePortName = this.getServicePortName();
        String other$servicePortName = other.getServicePortName();
        return !(this$servicePortName == null ? other$servicePortName != null : !this$servicePortName.equals(other$servicePortName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowPrivilegeEscalation = this.getAllowPrivilegeEscalation();
        result = result * 59 + ($allowPrivilegeEscalation == null ? 43 : ((Object)$allowPrivilegeEscalation).hashCode());
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $expose = this.getExpose();
        result = result * 59 + ($expose == null ? 43 : ((Object)$expose).hashCode());
        Long $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $runAsNonRoot = this.getRunAsNonRoot();
        result = result * 59 + ($runAsNonRoot == null ? 43 : ((Object)$runAsNonRoot).hashCode());
        Long $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 43 : ((Object)$runAsUser).hashCode());
        Long $servicePort = this.getServicePort();
        result = result * 59 + ($servicePort == null ? 43 : ((Object)$servicePort).hashCode());
        List<String> $capabilitiesAdd = this.getCapabilitiesAdd();
        result = result * 59 + ($capabilitiesAdd == null ? 43 : ((Object)$capabilitiesAdd).hashCode());
        List<String> $capabilitiesDrop = this.getCapabilitiesDrop();
        result = result * 59 + ($capabilitiesDrop == null ? 43 : ((Object)$capabilitiesDrop).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        ImagePullPolicy $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : ((Object)((Object)$imagePullPolicy)).hashCode());
        String $limitCPU = this.getLimitCPU();
        result = result * 59 + ($limitCPU == null ? 43 : $limitCPU.hashCode());
        String $limitMemory = this.getLimitMemory();
        result = result * 59 + ($limitMemory == null ? 43 : $limitMemory.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $portName = this.getPortName();
        result = result * 59 + ($portName == null ? 43 : $portName.hashCode());
        String $requestCPU = this.getRequestCPU();
        result = result * 59 + ($requestCPU == null ? 43 : $requestCPU.hashCode());
        String $requestMemory = this.getRequestMemory();
        result = result * 59 + ($requestMemory == null ? 43 : $requestMemory.hashCode());
        SeccompProfileType $seccompProfileType = this.getSeccompProfileType();
        result = result * 59 + ($seccompProfileType == null ? 43 : ((Object)((Object)$seccompProfileType)).hashCode());
        String $servicePortName = this.getServicePortName();
        result = result * 59 + ($servicePortName == null ? 43 : $servicePortName.hashCode());
        return result;
    }

    public static enum ImagePullPolicy {
        ALWAYS("Always"),
        NEVER("Never"),
        IFNOTPRESENT("IfNotPresent");

        String value;

        private ImagePullPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum SeccompProfileType {
        UNCONFINED("Unconfined"),
        RUNTIMEDEFAULT("RuntimeDefault");

        String value;

        private SeccompProfileType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

