/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.PipeStatus;
import org.apache.camel.v1.pipestatus.Conditions;
import org.apache.camel.v1.pipestatus.ConditionsBuilder;
import org.apache.camel.v1.pipestatus.ConditionsFluent;

public class PipeStatusFluent<A extends PipeStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ConditionsBuilder> conditions;
    private Long observedGeneration;
    private String phase;
    private Integer replicas;
    private String selector;

    public PipeStatusFluent() {
    }

    public PipeStatusFluent(PipeStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PipeStatus instance) {
        PipeStatus pipeStatus = instance = instance != null ? instance : new PipeStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withReplicas(instance.getReplicas());
            this.withSelector(instance.getSelector());
        }
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPipestatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPipestatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPipestatusConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? PipeStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public String getSelector() {
        return this.selector;
    }

    public A withSelector(String selector) {
        this.selector = selector;
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipeStatusFluent that = (PipeStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        return Objects.equals(this.selector, that.selector);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.observedGeneration, this.phase, this.replicas, this.selector, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)PipeStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endPipestatusCondition() {
            return this.and();
        }
    }
}

