/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static String xpath(String xml, String xpath) {
        return (String)XmlUtil.xpath(xml, xpath, XPathConstants.STRING);
    }

    public static Object xpath(String xml, String xpath, QName returnType) {
        try {
            DocumentBuilder builder = SharedDocumentBuilder.get();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPathExpression expr = xPathfactory.newXPath().compile(xpath);
            return expr.evaluate(doc, returnType);
        }
        catch (ParserConfigurationException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (SAXException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Object xpathHandlingIllegalChars(String xml, String xpath) {
        return XmlUtil.xpathHandlingIllegalChars(xml, xpath, XPathConstants.STRING);
    }

    @Beta
    public static Object xpathHandlingIllegalChars(String xml, String xpath, QName returnType) {
        try {
            return XmlUtil.xpath(xml, xpath, returnType);
        }
        catch (Exception e) {
            SAXException saxe = (SAXException)Exceptions.getFirstThrowableOfType((Throwable)e, SAXException.class);
            if (saxe != null && saxe.toString().contains("&#")) {
                Escaper escaper = new Escaper();
                String xmlCleaned = escaper.escape(xml);
                try {
                    Object result = XmlUtil.xpath(xmlCleaned, xpath, returnType);
                    if (result instanceof String) {
                        return escaper.unescape((String)result);
                    }
                    return result;
                }
                catch (Exception e2) {
                    Exceptions.propagateIfFatal((Throwable)e2);
                }
            }
            throw e;
        }
    }

    @Beta
    protected static class Escaper {
        protected Escaper() {
        }

        public String escape(String string) {
            String unicodeRegex = "&#([x0-9a-fA-f]{1,5});";
            return string.replaceAll("BR_UNICODE_", "NOT_BR_UNICODE_").replaceAll(unicodeRegex, "BR_UNICODE_$1;");
        }

        public String unescape(String string) {
            String unicodeRegex = "(?<!NOT_)BR_UNICODE_([x0-9a-fA-F]{1,5})";
            return string.replaceAll(unicodeRegex, "&#$1").replaceAll("NOT_BR_UNICODE_", "BR_UNICODE_");
        }
    }

    private static class SharedDocumentBuilder {
        private static ThreadLocal<DocumentBuilder> instance = new ThreadLocal();

        private SharedDocumentBuilder() {
        }

        public static DocumentBuilder get() throws ParserConfigurationException {
            DocumentBuilder result = instance.get();
            if (result == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                result = factory.newDocumentBuilder();
                instance.set(result);
            } else {
                result.reset();
            }
            return result;
        }
    }
}

