/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import java.util.List;
import java.util.Map;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.TransformSlice;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;

public class TransformRemove
extends WorkflowTransformDefault {
    private String removal;

    @Override
    protected void initCheckingDefinition() {
        List d = this.definition.subList(1, this.definition.size());
        if (d.size() != 1) {
            throw new IllegalArgumentException("Transform 'remove' requires a single argument being the item (for a map) or index (for a list) to remove");
        }
        this.removal = (String)d.get(0);
    }

    public Object apply(Object v) {
        if (v instanceof Map) {
            MutableMap vm = MutableMap.copyOf((Map)((Map)v));
            Object removalResolved = this.context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, this.removal);
            vm.remove(removalResolved);
            return vm;
        }
        if (v instanceof Iterable) {
            MutableList vl = MutableList.copyOf((Iterable)((Iterable)v));
            Integer removalIndex = TransformSlice.resolveAs(this.removal, this.context, "Argument", true, Integer.class, "an integer");
            if (removalIndex < 0) {
                removalIndex = vl.size() + removalIndex;
            }
            if (removalIndex < 0 || removalIndex > vl.size()) {
                throw new IllegalArgumentException("Invalid removal index " + removalIndex + "; list is size " + vl.size());
            }
            vl.remove(removalIndex);
            return vl;
        }
        throw new IllegalArgumentException("Invalid value for remove transform; expects a map or list, not " + (v == null ? "null" : v.getClass()));
    }
}

