/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.DeprecatedKeysMappingBuilder;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.StringPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationPropertiesFromBrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(LocationPropertiesFromBrooklynProperties.class);
    protected static final Map<String, String> DEPRECATED_KEYS_MAPPING = new DeprecatedKeysMappingBuilder(LOG).camelToHyphen(LocationConfigKeys.DISPLAY_NAME).camelToHyphen(LocationConfigKeys.PRIVATE_KEY_FILE).camelToHyphen(LocationConfigKeys.PRIVATE_KEY_DATA).camelToHyphen(LocationConfigKeys.PRIVATE_KEY_PASSPHRASE).camelToHyphen(LocationConfigKeys.PUBLIC_KEY_FILE).camelToHyphen(LocationConfigKeys.PUBLIC_KEY_DATA).camelToHyphen(LocationConfigKeys.CALLER_CONTEXT).build();

    public Map<String, Object> getLocationProperties(String provider, String namedLocation, Map<String, ?> properties) {
        ConfigBag result = ConfigBag.newInstance();
        if (!Strings.isNullOrEmpty((String)provider)) {
            result.put(LocationConfigKeys.CLOUD_PROVIDER, provider);
        }
        result.putAll(this.transformDeprecated(this.getGenericLocationSingleWordProperties(properties)));
        if (!Strings.isNullOrEmpty((String)provider)) {
            result.putAll(this.transformDeprecated(this.getScopedLocationProperties(provider, properties)));
        }
        if (!Strings.isNullOrEmpty((String)namedLocation)) {
            result.putAll(this.transformDeprecated(this.getNamedLocationProperties(namedLocation, properties)));
        }
        LocationPropertiesFromBrooklynProperties.setLocalTempDir(properties, result);
        return result.getAllConfigRaw();
    }

    public static void setLocalTempDir(Map<String, ?> source, ConfigBag target) {
        String brooklynDataDir = (String)source.get(BrooklynServerConfig.getMgmtBaseDir(source));
        if (brooklynDataDir != null && brooklynDataDir.length() > 0) {
            String tempDir = Os.mergePaths((String[])new String[]{brooklynDataDir, "tmp", "ssh"});
            target.putIfAbsentAndNotNull(SshTool.PROP_LOCAL_TEMP_DIR, tempDir);
            Os.deleteOnExitEmptyParentsUpTo((File)new File(tempDir), (File)new File(brooklynDataDir));
        }
    }

    protected String getNamedProvider(String namedLocation, Map<String, ?> properties) {
        String key = String.format("brooklyn.location.named.%s", namedLocation);
        return (String)properties.get(key);
    }

    protected Map<String, Object> getGenericLocationSingleWordProperties(Map<String, ?> properties) {
        return this.getMatchingSingleWordProperties("brooklyn.location.", properties);
    }

    protected Map<String, Object> getScopedLocationProperties(String scopeSuffix, Map<String, ?> properties) {
        Preconditions.checkArgument((!scopeSuffix.startsWith(".") ? 1 : 0) != 0, (String)"scopeSuffix \"%s\" should not start with \".\"", (Object)scopeSuffix);
        Preconditions.checkArgument((!scopeSuffix.endsWith(".") ? 1 : 0) != 0, (String)"scopeSuffix \"%s\" should not end with \".\"", (Object)scopeSuffix);
        String prefix = String.format("brooklyn.location.%s.", scopeSuffix);
        return ConfigUtils.filterForPrefixAndStrip(properties, prefix).asMapWithStringKeys();
    }

    protected Map<String, Object> getMatchingProperties(String fullPrefix, Map<String, ?> properties) {
        return ConfigUtils.filterForPrefixAndStrip(properties, fullPrefix).asMapWithStringKeys();
    }

    protected Map<String, Object> getMatchingProperties(String fullPreferredPrefix, String fullDeprecatedPrefix, Map<String, ?> properties) {
        Map<String, Object> deprecatedResults = this.getMatchingProperties(fullDeprecatedPrefix, properties);
        Map<String, Object> results = this.getMatchingProperties(fullPreferredPrefix, properties);
        if (deprecatedResults.size() > 0) {
            LOG.warn("Deprecated use of properties prefix " + fullDeprecatedPrefix + "; instead use " + fullPreferredPrefix);
            return MutableMap.builder().putAll(deprecatedResults).putAll(results).build();
        }
        return results;
    }

    protected Map<String, Object> getMatchingSingleWordProperties(String fullPrefix, Map<String, ?> properties) {
        BrooklynProperties filteredProperties = ConfigUtils.filterForPrefixAndStrip(properties, fullPrefix);
        return ConfigUtils.filterFor(filteredProperties, (Predicate<? super String>)Predicates.not((Predicate)Predicates.containsPattern((String)"\\."))).asMapWithStringKeys();
    }

    protected Map<String, Object> getMatchingConcatenatedPrefixesPropertiesFirstPrefixRemoved(String firstPrefix, String secondPrefix, Map<String, ?> properties) {
        BrooklynProperties filteredProperties = ConfigUtils.filterForPrefixAndStrip(properties, firstPrefix);
        return ConfigUtils.filterFor(filteredProperties, (Predicate<? super String>)StringPredicates.startsWith((String)secondPrefix)).asMapWithStringKeys();
    }

    protected Map<String, Object> getMatchingSingleWordProperties(String fullPreferredPrefix, String fullDeprecatedPrefix, Map<String, ?> properties) {
        Map<String, Object> deprecatedResults = this.getMatchingSingleWordProperties(fullDeprecatedPrefix, properties);
        Map<String, Object> results = this.getMatchingSingleWordProperties(fullPreferredPrefix, properties);
        if (deprecatedResults.size() > 0) {
            LOG.warn("Deprecated use of properties prefix " + fullDeprecatedPrefix + "; instead use " + fullPreferredPrefix);
            return MutableMap.builder().putAll(deprecatedResults).putAll(results).build();
        }
        return results;
    }

    protected Map<String, Object> getNamedLocationProperties(String locationName, Map<String, ?> properties) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locationName) ? 1 : 0) != 0, (Object)"locationName should not be blank");
        String prefix = String.format("brooklyn.location.named.%s.", locationName);
        return ConfigUtils.filterForPrefixAndStrip(properties, prefix).asMapWithStringKeys();
    }

    protected Map<String, Object> transformDeprecated(Map<String, ?> properties) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Map<String, String> deprecatedKeysMapping = this.getDeprecatedKeysMapping();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (deprecatedKeysMapping.containsKey(key)) {
                String transformedKey = deprecatedKeysMapping.get(key);
                LOG.warn("Deprecated key {}, transformed to {}; will not be supported in future versions", new Object[]{key, transformedKey});
                result.put(transformedKey, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    protected Map<String, String> getDeprecatedKeysMapping() {
        return DEPRECATED_KEYS_MAPPING;
    }
}

