/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class AcksTo
implements IOMRMElement {
    private EndpointReference epr;
    private String rmNamespaceValue = null;
    private String addressingNamespaceValue = null;

    public AcksTo(String rmNamespaceValue) throws AxisFault {
        if (!this.isNamespaceSupported(rmNamespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", rmNamespaceValue));
        }
        this.rmNamespaceValue = rmNamespaceValue;
    }

    public AcksTo(EndpointReference epr, String rmNamespaceValue, String addressingNamespaceValue) throws AxisFault {
        this(rmNamespaceValue);
        this.addressingNamespaceValue = addressingNamespaceValue;
        this.epr = epr;
    }

    public String getNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public String getAddressingNamespaceValue() {
        return this.addressingNamespaceValue;
    }

    public Object fromOMElement(OMElement element) throws OMException, AxisFault {
        OMElement acksToPart = element.getFirstChildWithName(new QName(this.rmNamespaceValue, "AcksTo"));
        if (acksToPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noAcksToPart", element.toString()));
        }
        this.epr = EndpointReferenceHelper.fromOM((OMElement)acksToPart);
        Iterator children = acksToPart.getChildElements();
        while (children.hasNext() && this.addressingNamespaceValue == null) {
            OMElement child = (OMElement)children.next();
            if (!"Address".equals(child.getLocalName())) continue;
            this.addressingNamespaceValue = child.getNamespace().getNamespaceURI();
        }
        return this;
    }

    public OMElement toOMElement(OMElement element) throws OMException, AxisFault {
        if (this.epr == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotSetAcksTo", null));
        }
        OMFactory factory = element.getOMFactory();
        QName acksTo = new QName(this.rmNamespaceValue, "AcksTo", "wsrm");
        OMElement endpointElement = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)this.epr, (QName)acksTo, (String)this.addressingNamespaceValue);
        element.addChild((OMNode)endpointElement);
        return element;
    }

    public EndpointReference getEPR() {
        return this.epr;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

