/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.framework.PackageState;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageStateMBeanHandler
implements MBeanHandler {
    private String name;
    private StandardMBean mbean;
    private BundleContext context;
    private Logger logger;

    public PackageStateMBeanHandler(BundleContext context, Logger logger) {
        this.context = context;
        this.name = ObjectNameUtils.createFullObjectName(context, "osgi.core:type=packageState,version=1.5");
        this.logger = logger;
    }

    public StandardMBean getMbean() {
        return this.mbean;
    }

    public void open() {
        ServiceReference adminRef = this.context.getServiceReference(PackageAdmin.class.getCanonicalName());
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(adminRef);
        PackageState packageState = new PackageState(this.context, packageAdmin);
        try {
            this.mbean = new StandardMBean(packageState, PackageStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.logger.log(1, "Not compliant MBean", e);
        }
    }

    public void close() {
    }

    public String getName() {
        return this.name;
    }
}

