/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.servlet.ErrorMessage;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public abstract class ResultsWriter
extends org.musicbrainz.search.servlet.ResultsWriter {
    static final JAXBContext context = ResultsWriter.initContext();
    static final NamespacePrefixMapper prefixMapper = new PreferredMapper();
    static final JSONJAXBContext internalJsoncontext = ResultsWriter.initInternalJsonContext();
    static final JAXBContext jsonContext = ResultsWriter.initJsonContext();

    public String getMimeType() {
        return "application/xml; charset=UTF-8";
    }

    public String getJsonMimeType() {
        return "application/json; charset=UTF-8";
    }

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((String)"org.musicbrainz.mmd2");
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static JSONJAXBContext initInternalJsonContext() {
        try {
            return new JSONJAXBContext(JSONConfiguration.natural().build(), "org.musicbrainz.mmd2");
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static JAXBContext initJsonContext() {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>(3);
            properties.put("eclipselink.oxm.metadata-source", "oxml.xml");
            properties.put("eclipselink.media-type", "application/json");
            properties.put("eclipselink.json.include-root", false);
            properties.put("eclipselink.json.value-wrapper", "name");
            return JAXBContextFactory.createContext((Class[])new Class[]{Metadata.class}, properties);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        this.write(metadata, results);
        this.setIndexUpdateDate(metadata);
        return metadata;
    }

    public abstract void write(Metadata var1, Results var2) throws IOException;

    public void adjustForJson(Metadata metadata) {
    }

    public void write(PrintWriter out, Results results, String outputFormat, boolean isPretty) throws IOException {
        if (outputFormat.equals("xml")) {
            try {
                Metadata metadata = this.write(results);
                Marshaller m = context.createMarshaller();
                m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)prefixMapper);
                if (isPretty) {
                    m.setProperty("jaxb.formatted.output", (Object)true);
                }
                m.marshal((Object)metadata, (Writer)out);
            }
            catch (JAXBException je) {
                throw new IOException(je);
            }
        } else if (outputFormat.equals("jsonnew")) {
            try {
                Metadata metadata = this.write(results);
                this.adjustForJson(metadata);
                Marshaller m = jsonContext.createMarshaller();
                if (isPretty) {
                    m.setProperty("jaxb.formatted.output", (Object)true);
                }
                m.marshal((Object)metadata, (Writer)out);
            }
            catch (JAXBException je) {
                throw new IOException(je);
            }
        } else if (outputFormat.equals("json")) {
            try {
                Metadata metadata = this.write(results);
                this.adjustForJson(metadata);
                JSONMarshaller m = internalJsoncontext.createJSONMarshaller();
                if (isPretty) {
                    m.setProperty("jaxb.formatted.output", (Object)true);
                }
                m.marshallToJSON((Object)metadata, (Writer)out);
            }
            catch (JAXBException je) {
                throw new IOException(je);
            }
        } else {
            throw new RuntimeException(ErrorMessage.NO_HANDLER_FOR_TYPE_AND_FORMAT.getMsg(new Object[]{this.getClass(), outputFormat}));
        }
    }

    public void setIndexUpdateDate(Metadata metadata) {
        try {
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(this.serverLastUpdatedDate);
            XMLGregorianCalendar indexLastUpdatedTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            metadata.setCreated(indexLastUpdatedTime);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
    }
}

