/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Label;
import org.musicbrainz.mmd2.LabelList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class LabelWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        LabelList labelList = of.createLabelList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(labelList.getLabel(), results);
        labelList.setCount(BigInteger.valueOf(results.getTotalHits()));
        labelList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setLabelList(labelList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Label label = (Label)MMDSerializer.unserialize((String)doc.get((IndexField)LabelIndexField.LABEL_STORE), Label.class);
        label.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(label);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getLabelList().getLabel().size() > 0) {
            for (Label label : metadata.getLabelList().getLabel()) {
                if (label.getAliasList() == null) continue;
                for (Alias alias : label.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

