/*
Copyright (c) 2024 - 2025 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef _ROCDECODE_HOST_VERSION_H_
#define _ROCDECODE_HOST_VERSION_H_

/*!
 * \file
 * \brief rocDecode host version
 * \defgroup group_rocdecode_host_version rocdecode-host Version
 * \brief rocdecode-host version
 */

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define ROCDECODE_HOST_VERSION_MAJOR 1
#define ROCDECODE_HOST_VERSION_MINOR 0
#define ROCDECODE_HOST_VERSION_PATCH 0

/**
 * ROCDECODE_HOST_CHECK_VERSION:
 * @major: major version, like 1 in 1.2.3
 * @minor: minor version, like 2 in 1.2.3
 * @patch: patch version, like 3 in 1.2.3
 *
 * Evaluates to %TRUE if the version of ROCDECODE HOST is greater than
 * @major, @minor and @patch
 */
#define ROCDECODE_HOST_CHECK_VERSION(major, minor, patch) \
        (ROCDECODE_HOST_VERSION_MAJOR > (major) || \
        (ROCDECODE_HOST_VERSION_MAJOR == (major) && ROCDECODE_HOST_VERSION_MINOR > (minor)) || \
        (ROCDECODE_HOST_VERSION_MAJOR == (major) && ROCDECODE_HOST_VERSION_MINOR == (minor) && ROCDECODE_HOST_VERSION_PATCH >= (patch)))

#ifdef __cplusplus
}  // end extern "C" block
#endif

#endif  //_ROCDECODE_HOST_VERSION_H_  header guard
