/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplInteger
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    private final int literal;
    @Nonnull
    private final OWLDatatype datatype;
    private final int hashcode;

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImplInteger(int literal, @Nonnull OWLDatatype datatype) {
        this.literal = literal;
        this.datatype = OWLAPIPreconditions.checkNotNull(datatype, "datatype cannot be null");
        this.hashcode = this.getHashCode();
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add(this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code = code * 37 + this.literal * 65536;
        return code;
    }

    @Override
    public String getLiteral() {
        return Integer.toString(this.literal);
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return false;
    }

    @Override
    public boolean hasLang() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int parseInteger() {
        return this.literal;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean parseBoolean() {
        throw new NumberFormatException("this literal is not a boolean but a int");
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public double parseDouble() {
        throw new NumberFormatException("this literal is not a double but a int");
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public float parseFloat() {
        throw new NumberFormatException("this literal is not a float but a int");
    }

    @Override
    @Nonnull
    public String getLang() {
        return "";
    }

    @Override
    public boolean hasLang(String lang) {
        return false;
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        OWLLiteral other;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof OWLLiteralImplInteger) {
            OWLLiteralImplInteger other2 = (OWLLiteralImplInteger)obj;
            return this.literal == other2.literal;
        }
        if (obj instanceof OWLLiteral && (other = (OWLLiteral)obj).isInteger() && other.getLiteral().charAt(0) != '0') {
            try {
                return this.literal == other.parseInteger();
            }
            catch (NumberFormatException e) {
                return this.getLiteral().equals(other.getLiteral());
            }
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        try {
            return Integer.compare(this.literal, other.parseInteger());
        }
        catch (NumberFormatException e) {
            return diff;
        }
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

