/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.scan.QueryRangeFunctionTableScanBuilder;
import org.opensearch.sql.prometheus.planner.logical.PrometheusLogicalPlanOptimizerFactory;
import org.opensearch.sql.prometheus.request.PrometheusQueryRequest;
import org.opensearch.sql.prometheus.request.system.PrometheusDescribeMetricRequest;
import org.opensearch.sql.prometheus.storage.PrometheusMetricDefaultSchema;
import org.opensearch.sql.prometheus.storage.PrometheusMetricScan;
import org.opensearch.sql.prometheus.storage.implementor.PrometheusDefaultImplementor;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class PrometheusMetricTable
implements Table {
    private final PrometheusClient prometheusClient;
    private final String metricName;
    private final PrometheusQueryRequest prometheusQueryRequest;
    private Map<String, ExprType> cachedFieldTypes = null;

    public PrometheusMetricTable(PrometheusClient prometheusService, @Nonnull String metricName) {
        this.prometheusClient = prometheusService;
        this.metricName = metricName;
        this.prometheusQueryRequest = null;
    }

    public PrometheusMetricTable(PrometheusClient prometheusService, @Nonnull PrometheusQueryRequest prometheusQueryRequest) {
        this.prometheusClient = prometheusService;
        this.metricName = null;
        this.prometheusQueryRequest = prometheusQueryRequest;
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("Prometheus metric exists operation is not supported");
    }

    @Override
    public void create(Map<String, ExprType> schema) {
        throw new UnsupportedOperationException("Prometheus metric create operation is not supported");
    }

    @Override
    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldTypes == null) {
            if (this.metricName != null) {
                this.cachedFieldTypes = new PrometheusDescribeMetricRequest(this.prometheusClient, null, this.metricName).getFieldTypes();
            } else {
                this.cachedFieldTypes = new HashMap<String, ExprType>(PrometheusMetricDefaultSchema.DEFAULT_MAPPING.getMapping());
                this.cachedFieldTypes.put("@labels", ExprCoreType.STRING);
            }
        }
        return this.cachedFieldTypes;
    }

    @Override
    public PhysicalPlan implement(LogicalPlan plan) {
        PrometheusMetricScan metricScan = new PrometheusMetricScan(this.prometheusClient);
        return plan.accept(new PrometheusDefaultImplementor(), metricScan);
    }

    @Override
    public LogicalPlan optimize(LogicalPlan plan) {
        return PrometheusLogicalPlanOptimizerFactory.create().optimize(plan);
    }

    @Override
    public TableScanBuilder createScanBuilder() {
        if (this.metricName == null) {
            return new QueryRangeFunctionTableScanBuilder(this.prometheusClient, this.prometheusQueryRequest);
        }
        return null;
    }

    @Generated
    public String getMetricName() {
        return this.metricName;
    }

    @Generated
    public PrometheusQueryRequest getPrometheusQueryRequest() {
        return this.prometheusQueryRequest;
    }
}

