/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class NestedOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final Set<String> fields;
    private final Map<String, List<String>> groupedPathsAndFields;
    private List<Map<String, ExprValue>> result = new ArrayList<Map<String, ExprValue>>();
    private final List<String> nonNestedFields = new ArrayList<String>();
    private ListIterator<Map<String, ExprValue>> flattenedResult = this.result.listIterator();

    public NestedOperator(PhysicalPlan input, List<Map<String, ReferenceExpression>> fields2) {
        this.input = input;
        this.fields = fields2.stream().map(m4 -> ((ReferenceExpression)m4.get("field")).toString()).collect(Collectors.toSet());
        this.groupedPathsAndFields = fields2.stream().collect(Collectors.groupingBy(m4 -> ((ReferenceExpression)m4.get("path")).toString(), Collectors.mapping(m4 -> ((ReferenceExpression)m4.get("field")).toString(), Collectors.toList())));
    }

    public NestedOperator(PhysicalPlan input, Set<String> fields2, Map<String, List<String>> groupedPathsAndFields) {
        this.input = input;
        this.fields = fields2;
        this.groupedPathsAndFields = groupedPathsAndFields;
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor2, C context) {
        return visitor2.visitNested(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext() || this.flattenedResult.hasNext();
    }

    @Override
    public ExprValue next() {
        if (!this.flattenedResult.hasNext()) {
            this.result.clear();
            this.nonNestedFields.clear();
            ExprValue inputValue = (ExprValue)this.input.next();
            this.generateNonNestedFieldsMap(inputValue);
            for (String field : this.fields) {
                this.result = this.flatten(field, inputValue, this.result);
            }
            for (String nonNestedField : this.nonNestedFields) {
                this.result = this.flatten(nonNestedField, inputValue, this.result);
            }
            if (this.result.isEmpty()) {
                this.flattenedResult = this.result.listIterator();
                return new ExprTupleValue(new LinkedHashMap<String, ExprValue>());
            }
            this.flattenedResult = this.result.listIterator();
        }
        return new ExprTupleValue(new LinkedHashMap<String, ExprValue>(this.flattenedResult.next()));
    }

    public void generateNonNestedFieldsMap(ExprValue inputMap) {
        for (Map.Entry<String, ExprValue> inputField : inputMap.tupleValue().entrySet()) {
            boolean foundNestedField = this.fields.stream().anyMatch(field -> field.split("\\.")[0].equalsIgnoreCase((String)inputField.getKey()));
            if (foundNestedField) continue;
            this.nonNestedFields.add(inputField.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, ExprValue>> flatten(String nestedField, ExprValue row, List<Map<String, ExprValue>> prevList) {
        ArrayList<Map<String, ExprValue>> copy2 = new ArrayList<Map<String, ExprValue>>();
        ArrayList<Map<String, ExprValue>> newList = new ArrayList<Map<String, ExprValue>>();
        ExprValue nestedObj = null;
        this.getNested(nestedField, nestedField, row, copy2, nestedObj);
        if (prevList.size() == 0) {
            return copy2;
        }
        if (this.containSamePath((Map)copy2.get(0))) {
            Iterator<Map<String, ExprValue>> resultIt = this.result.iterator();
            Map<String, ExprValue> resultVal = resultIt.next();
            Iterator copyIt = copy2.iterator();
            Map map2 = (Map)copyIt.next();
            for (int i = 0; i < this.result.size(); ++i) {
                void var10_14;
                resultVal.putAll((Map<String, ExprValue>)var10_14);
                if (copyIt.hasNext()) {
                    Map map3 = (Map)copyIt.next();
                }
                if (!resultIt.hasNext()) continue;
                resultVal = resultIt.next();
            }
            return this.result;
        }
        for (Map<String, ExprValue> prevMap : prevList) {
            for (Map map4 : copy2) {
                newList.add(Stream.of(map4, prevMap).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        }
        return newList;
    }

    boolean containSamePath(Map<String, ExprValue> newMap) {
        String newKey = newMap.keySet().iterator().next();
        Map<String, ExprValue> resultMap = this.result.iterator().next();
        for (Map.Entry<String, List<String>> entry : this.groupedPathsAndFields.entrySet()) {
            if (!entry.getValue().contains(newKey)) continue;
            for (Map.Entry<String, ExprValue> map : resultMap.entrySet()) {
                if (!entry.getValue().contains(map.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private void getNested(String field, String nestedField, ExprValue row, List<Map<String, ExprValue>> ret, ExprValue nestedObj) {
        ExprValue currentObj = nestedObj == null ? row : nestedObj;
        String[] splitKeys = nestedField.split("\\.");
        if (currentObj instanceof ExprTupleValue) {
            ExprTupleValue currentMap = (ExprTupleValue)currentObj;
            if (currentMap.tupleValue().containsKey(splitKeys[0])) {
                currentObj = currentMap.tupleValue().get(splitKeys[0]);
            } else {
                currentObj = null;
                ret.add(new LinkedHashMap<String, ExprNullValue>(Map.of(field, ExprNullValue.of())));
            }
        } else if (currentObj instanceof ExprCollectionValue) {
            ExprValue arrayObj = currentObj;
            for (int x = 0; x < arrayObj.collectionValue().size(); ++x) {
                currentObj = arrayObj.collectionValue().get(x);
                this.getNested(field, nestedField, row, ret, currentObj);
                currentObj = null;
            }
        } else {
            currentObj = null;
        }
        if (currentObj != null && (StringUtils.substringAfterLast(field, ".").equals(nestedField) || !field.contains("."))) {
            ret.add(new LinkedHashMap<String, ExprValue>(Map.of(field, currentObj)));
        } else if (currentObj != null) {
            this.getNested(field, nestedField.substring(nestedField.indexOf(".") + 1), row, ret, currentObj);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NestedOperator)) {
            return false;
        }
        NestedOperator other = (NestedOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        Set<String> this$fields = this.getFields();
        Set<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Map<String, List<String>> this$groupedPathsAndFields = this.getGroupedPathsAndFields();
        Map<String, List<String>> other$groupedPathsAndFields = other.getGroupedPathsAndFields();
        return !(this$groupedPathsAndFields == null ? other$groupedPathsAndFields != null : !((Object)this$groupedPathsAndFields).equals(other$groupedPathsAndFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NestedOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        PhysicalPlan $input = this.getInput();
        result2 = result2 * 59 + ($input == null ? 43 : $input.hashCode());
        Set<String> $fields = this.getFields();
        result2 = result2 * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Map<String, List<String>> $groupedPathsAndFields = this.getGroupedPathsAndFields();
        result2 = result2 * 59 + ($groupedPathsAndFields == null ? 43 : ((Object)$groupedPathsAndFields).hashCode());
        return result2;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Set<String> getFields() {
        return this.fields;
    }

    @Generated
    public Map<String, List<String>> getGroupedPathsAndFields() {
        return this.groupedPathsAndFields;
    }
}

