/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OpenSearchRelInputTranslator
implements RelJson.InputTranslator {
    private final RelDataType rowType;

    public OpenSearchRelInputTranslator(RelDataType rowType) {
        this.rowType = rowType;
    }

    @Override
    public RexNode translateInput(RelJson relJson, int input, Map<String, @Nullable Object> map, RelInput relInput) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (input < this.rowType.getFieldCount()) {
            RelDataTypeField field = this.rowType.getFieldList().get(input);
            return rexBuilder.makeInputRef(field.getType(), input);
        }
        throw new RuntimeException("input field " + input + " is out of range");
    }
}

