/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rex.RexBuilder;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.FilterScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.opensearch.storage.script.CalciteScriptEngine;
import org.opensearch.sql.opensearch.storage.script.ExpressionScriptEngine;
import org.opensearch.sql.opensearch.storage.serde.DefaultExpressionSerializer;
import org.opensearch.sql.opensearch.storage.serde.SerializationWrapper;

public class CompoundedScriptEngine
implements ScriptEngine {
    public static final String COMPOUNDED_LANG_NAME = "opensearch_compounded_script";
    private static final ExpressionScriptEngine v2ExpressionScriptEngine = new ExpressionScriptEngine(new DefaultExpressionSerializer());
    private final CalciteScriptEngine calciteScriptEngine;

    public CompoundedScriptEngine() {
        RexBuilder rexBuilder = new RexBuilder(OpenSearchTypeFactory.TYPE_FACTORY);
        RelOptCluster cluster = RelOptCluster.create(new VolcanoPlanner(), rexBuilder);
        this.calciteScriptEngine = new CalciteScriptEngine(cluster);
    }

    public String getType() {
        return COMPOUNDED_LANG_NAME;
    }

    public <T> T compile(String scriptName, String scriptCode, ScriptContext<T> context, Map<String, String> options) {
        SerializationWrapper.LangScriptWrapper unwrapped = SerializationWrapper.unwrapLangType(scriptCode);
        return switch (unwrapped.langType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.calciteScriptEngine.compile(scriptName, unwrapped.script, context, options);
            case 0 -> v2ExpressionScriptEngine.compile(scriptName, unwrapped.script, context, options);
        };
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Set.of(FilterScript.CONTEXT, AggregationScript.CONTEXT);
    }

    @Generated
    public CompoundedScriptEngine(CalciteScriptEngine calciteScriptEngine) {
        this.calciteScriptEngine = calciteScriptEngine;
    }

    public static enum ScriptEngineType {
        V2("v2"),
        CALCITE("calcite");

        private final String type;

        private ScriptEngineType(String type2) {
            this.type = type2;
        }

        public static ScriptEngineType fromString(String value) {
            for (ScriptEngineType engineType : ScriptEngineType.values()) {
                if (!engineType.type.equalsIgnoreCase(value)) continue;
                return engineType;
            }
            throw new IllegalArgumentException("Unknown script engine type: " + value);
        }

        @JsonCreator
        public static ScriptEngineType fromJson(String value) {
            return ScriptEngineType.fromString(value);
        }

        @JsonValue
        public String toJson() {
            return this.type;
        }
    }
}

