/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.frame;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;
import shaded.com.google.common.collect.PeekingIterator;

public class CurrentRowWindowFrame
implements WindowFrame {
    private final WindowDefinition windowDefinition;
    private ExprValue previous;
    private ExprValue current;

    @Override
    public boolean isNewPartition() {
        List<ExprValue> curValues;
        Objects.requireNonNull(this.current);
        if (this.previous == null) {
            return true;
        }
        List<ExprValue> preValues = this.resolve(this.windowDefinition.getPartitionByList(), this.previous);
        return !preValues.equals(curValues = this.resolve(this.windowDefinition.getPartitionByList(), this.current));
    }

    @Override
    public void load(PeekingIterator<ExprValue> it) {
        this.previous = this.current;
        this.current = it.next();
    }

    @Override
    public ExprValue current() {
        return this.current;
    }

    public ExprValue previous() {
        return this.previous;
    }

    private List<ExprValue> resolve(List<Expression> expressions, ExprValue row) {
        BindingTuple valueEnv = row.bindingTuples();
        return expressions.stream().map(expr -> expr.valueOf(valueEnv)).collect(Collectors.toList());
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public List<ExprValue> next() {
        return Collections.emptyList();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurrentRowWindowFrame)) {
            return false;
        }
        CurrentRowWindowFrame other = (CurrentRowWindowFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WindowDefinition this$windowDefinition = this.getWindowDefinition();
        WindowDefinition other$windowDefinition = other.getWindowDefinition();
        if (this$windowDefinition == null ? other$windowDefinition != null : !((Object)this$windowDefinition).equals(other$windowDefinition)) {
            return false;
        }
        ExprValue this$previous = this.previous;
        ExprValue other$previous = other.previous;
        if (this$previous == null ? other$previous != null : !this$previous.equals(other$previous)) {
            return false;
        }
        ExprValue this$current = this.current;
        ExprValue other$current = other.current;
        return !(this$current == null ? other$current != null : !this$current.equals(other$current));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CurrentRowWindowFrame;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        WindowDefinition $windowDefinition = this.getWindowDefinition();
        result2 = result2 * 59 + ($windowDefinition == null ? 43 : ((Object)$windowDefinition).hashCode());
        ExprValue $previous = this.previous;
        result2 = result2 * 59 + ($previous == null ? 43 : $previous.hashCode());
        ExprValue $current = this.current;
        result2 = result2 * 59 + ($current == null ? 43 : $current.hashCode());
        return result2;
    }

    @Generated
    public CurrentRowWindowFrame(WindowDefinition windowDefinition) {
        this.windowDefinition = windowDefinition;
    }

    @Generated
    public String toString() {
        return "CurrentRowWindowFrame(windowDefinition=" + String.valueOf(this.getWindowDefinition()) + ", previous=" + String.valueOf(this.previous) + ", current=" + String.valueOf(this.current) + ")";
    }

    @Generated
    public WindowDefinition getWindowDefinition() {
        return this.windowDefinition;
    }
}

