/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFormatterUtil;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class FormatFunction
extends ImplementorUDF {
    public FormatFunction(ExprType functionType) {
        super(new DataFormatImplementor(functionType), NullPolicy.ANY);
        if (!functionType.equals(ExprCoreType.DATE) && !functionType.equals(ExprCoreType.TIME)) {
            throw new IllegalArgumentException("Function type can only be DATE or TIME, but got: " + String.valueOf(functionType));
        }
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATETIME_OR_STRING_STRING;
    }

    public static class DataFormatImplementor
    implements NotNullImplementor {
        private final ExprType functionType;

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ExprType type2 = OpenSearchTypeFactory.convertRelDataTypeToExprType(call.getOperands().getFirst().getType());
            MethodCallExpression functionProperties = Expressions.call(UserDefinedFunctionUtils.class, "restoreFunctionProperties", new Expression[]{translator.getRoot()});
            MethodCallExpression datetime = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{translatedOperands.get(0), Expressions.constant(type2)});
            NewExpression format = Expressions.new_(ExprStringValue.class, new Expression[]{translatedOperands.get(1)});
            if (ExprCoreType.TIME.equals(this.functionType)) {
                return Expressions.call(DataFormatImplementor.class, "timeFormat", new Expression[]{datetime, format});
            }
            if (ExprCoreType.TIME.equals(type2)) {
                return Expressions.call(DataFormatImplementor.class, "dateFormatForTime", new Expression[]{functionProperties, format, datetime});
            }
            return Expressions.call(DataFormatImplementor.class, "dateFormat", new Expression[]{datetime, format});
        }

        public static String dateFormat(ExprValue date, ExprStringValue format) {
            return DateTimeFormatterUtil.getFormattedDate(date, format).stringValue();
        }

        public static String dateFormatForTime(FunctionProperties functionProperties, ExprStringValue format, ExprValue time) {
            return DateTimeFormatterUtil.getFormattedDateOfToday(format, time, functionProperties.getQueryStartClock()).stringValue();
        }

        public static String timeFormat(ExprValue time, ExprStringValue format) {
            return DateTimeFormatterUtil.getFormattedTime(time, format).stringValue();
        }

        @Generated
        public DataFormatImplementor(ExprType functionType) {
            this.functionType = functionType;
        }
    }
}

