/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import java.text.ParsePosition;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.CalendarLookup;
import org.opensearch.sql.expression.function.FunctionProperties;
import shaded.com.google.common.collect.ImmutableMap;

public class DateTimeFormatterUtil {
    private static final int SUFFIX_SPECIAL_START_TH = 11;
    private static final int SUFFIX_SPECIAL_END_TH = 13;
    private static final String SUFFIX_SPECIAL_TH = "th";
    private static final String NANO_SEC_FORMAT = "'%06d'";
    private static final Map<Integer, String> SUFFIX_CONVERTER = ImmutableMap.builder().put(1, "st").put(2, "nd").put(3, "rd").build();
    public static final Map<String, DateTimeFormatHandler> DATE_HANDLERS = ImmutableMap.builder().put("%a", date -> "EEE").put("%b", date -> "LLL").put("%c", date -> "MM").put("%d", date -> "dd").put("%e", date -> "d").put("%H", date -> "HH").put("%h", date -> "hh").put("%I", date -> "hh").put("%i", date -> "mm").put("%j", date -> "DDD").put("%k", date -> "H").put("%l", date -> "h").put("%p", date -> "a").put("%M", date -> "LLLL").put("%m", date -> "MM").put("%r", date -> "hh:mm:ss a").put("%S", date -> "ss").put("%s", date -> "ss").put("%T", date -> "HH:mm:ss").put("%W", date -> "EEEE").put("%Y", date -> "yyyy").put("%y", date -> "yy").put("%D", date -> String.format(Locale.ROOT, "'%d%s'", date.getDayOfMonth(), DateTimeFormatterUtil.getSuffix(date.getDayOfMonth()))).put("%f", date -> String.format(Locale.ROOT, NANO_SEC_FORMAT, date.getNano() / 1000)).put("%w", date -> String.format(Locale.ROOT, "'%d'", date.getDayOfWeek().getValue())).put("%U", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(0, date.toLocalDate()))).put("%u", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(1, date.toLocalDate()))).put("%V", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(2, date.toLocalDate()))).put("%v", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getWeekNumber(3, date.toLocalDate()))).put("%X", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getYearNumber(2, date.toLocalDate()))).put("%x", date -> String.format(Locale.ROOT, "'%d'", CalendarLookup.getYearNumber(3, date.toLocalDate()))).build();
    private static final Map<String, DateTimeFormatHandler> TIME_HANDLERS = ImmutableMap.builder().put("%a", date -> null).put("%b", date -> null).put("%c", date -> "0").put("%d", date -> "00").put("%e", date -> "0").put("%H", date -> "HH").put("%h", date -> "hh").put("%I", date -> "hh").put("%i", date -> "mm").put("%j", date -> null).put("%k", date -> "H").put("%l", date -> "h").put("%p", date -> "a").put("%M", date -> null).put("%m", date -> "00").put("%r", date -> "hh:mm:ss a").put("%S", date -> "ss").put("%s", date -> "ss").put("%T", date -> "HH:mm:ss").put("%W", date -> null).put("%Y", date -> "0000").put("%y", date -> "00").put("%D", date -> null).put("%f", date -> String.format(Locale.ROOT, NANO_SEC_FORMAT, date.getNano() / 1000)).put("%w", date -> null).put("%U", date -> null).put("%u", date -> null).put("%V", date -> null).put("%v", date -> null).put("%X", date -> null).put("%x", date -> null).build();
    private static final Map<String, String> STR_TO_DATE_FORMATS = ImmutableMap.builder().put("%a", "EEE").put("%b", "LLL").put("%c", "M").put("%d", "d").put("%e", "d").put("%H", "H").put("%h", "H").put("%I", "h").put("%i", "m").put("%j", "DDD").put("%k", "H").put("%l", "h").put("%p", "a").put("%M", "LLLL").put("%m", "M").put("%r", "hh:mm:ss a").put("%S", "s").put("%s", "s").put("%T", "HH:mm:ss").put("%W", "EEEE").put("%Y", "u").put("%y", "uu").put("%f", "n").put("%D", "d").put("%w", "e").put("%U", "w").put("%u", "w").put("%V", "w").put("%v", "w").put("%X", "u").put("%x", "u").build();
    private static final Pattern pattern = Pattern.compile("%.");
    private static final Pattern CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN = Pattern.compile("(?<!%)[a-zA-Z&&[^aydmshiHIMYDSEL]]+");
    private static final String MOD_LITERAL = "%";

    private DateTimeFormatterUtil() {
    }

    static StringBuffer getCleanFormat(ExprValue formatExpr) {
        return DateTimeFormatterUtil.getCleanFormat(formatExpr.stringValue());
    }

    public static StringBuffer getCleanFormat(String formatStr) {
        StringBuffer cleanFormat = new StringBuffer();
        Matcher m4 = CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN.matcher(formatStr);
        while (m4.find()) {
            m4.appendReplacement(cleanFormat, String.format("'%s'", m4.group()));
        }
        m4.appendTail(cleanFormat);
        return cleanFormat;
    }

    public static ExprValue getFormattedString(ExprValue formatExpr, Map<String, DateTimeFormatHandler> handler, LocalDateTime datetime) {
        StringBuffer cleanFormat = DateTimeFormatterUtil.getCleanFormat(formatExpr);
        Matcher matcher = pattern.matcher(cleanFormat.toString());
        StringBuffer format = new StringBuffer();
        try {
            while (matcher.find()) {
                matcher.appendReplacement(format, handler.getOrDefault(matcher.group(), d -> String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))).getFormat(datetime));
            }
        }
        catch (Exception e) {
            return ExprNullValue.of();
        }
        matcher.appendTail(format);
        return new ExprStringValue(datetime.format(DateTimeFormatter.ofPattern(format.toString(), Locale.ENGLISH)));
    }

    public static String getFormattedDatetime(LocalDateTime datetime, String formatStr) {
        return DateTimeFormatterUtil.getFormattedString(new ExprStringValue(formatStr), DATE_HANDLERS, datetime).stringValue();
    }

    public static ExprValue getFormattedDate(ExprValue dateExpr, ExprValue formatExpr) {
        LocalDateTime date = dateExpr.timestampValue().atZone(ZoneOffset.UTC).toLocalDateTime();
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    public static ExprValue getFormattedDateOfToday(ExprValue formatExpr, ExprValue time, Clock current) {
        LocalDateTime date = LocalDateTime.of(LocalDate.now(current), time.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    public static ExprValue getFormattedTime(ExprValue timeExpr, ExprValue formatExpr) {
        LocalDateTime time = LocalDateTime.of(LocalDate.now(), timeExpr.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, TIME_HANDLERS, time);
    }

    private static boolean canGetDate(TemporalAccessor ta) {
        return ta.isSupported(ChronoField.YEAR) && ta.isSupported(ChronoField.MONTH_OF_YEAR) && ta.isSupported(ChronoField.DAY_OF_MONTH);
    }

    private static boolean canGetTime(TemporalAccessor ta) {
        return ta.isSupported(ChronoField.HOUR_OF_DAY) && ta.isSupported(ChronoField.MINUTE_OF_HOUR) && ta.isSupported(ChronoField.SECOND_OF_MINUTE);
    }

    static ExprValue parseStringWithDateOrTime(FunctionProperties fp, ExprValue datetimeStringExpr, ExprValue formatExpr) {
        TemporalAccessor taWithMissingFields;
        StringBuffer cleanFormat = DateTimeFormatterUtil.getCleanFormat(formatExpr);
        Matcher matcher = pattern.matcher(cleanFormat.toString());
        StringBuffer format = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(format, STR_TO_DATE_FORMATS.getOrDefault(matcher.group(), String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))));
        }
        matcher.appendTail(format);
        try {
            taWithMissingFields = new DateTimeFormatterBuilder().appendPattern(format.toString()).toFormatter().withResolverStyle(ResolverStyle.STRICT).parseUnresolved(datetimeStringExpr.stringValue(), new ParsePosition(0));
            if (taWithMissingFields == null) {
                throw new DateTimeException("Input string could not be parsed properly.");
            }
            if (!DateTimeFormatterUtil.canGetDate(taWithMissingFields) && !DateTimeFormatterUtil.canGetTime(taWithMissingFields)) {
                throw new DateTimeException("Not enough data to build a valid Date, Time, or Datetime.");
            }
        }
        catch (DateTimeException e) {
            return ExprNullValue.of();
        }
        int year = taWithMissingFields.isSupported(ChronoField.YEAR) ? taWithMissingFields.get(ChronoField.YEAR) : 2000;
        int month = taWithMissingFields.isSupported(ChronoField.MONTH_OF_YEAR) ? taWithMissingFields.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = taWithMissingFields.isSupported(ChronoField.DAY_OF_MONTH) ? taWithMissingFields.get(ChronoField.DAY_OF_MONTH) : 1;
        int hour = taWithMissingFields.isSupported(ChronoField.HOUR_OF_DAY) ? taWithMissingFields.get(ChronoField.HOUR_OF_DAY) : 0;
        int minute = taWithMissingFields.isSupported(ChronoField.MINUTE_OF_HOUR) ? taWithMissingFields.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = taWithMissingFields.isSupported(ChronoField.SECOND_OF_MINUTE) ? taWithMissingFields.get(ChronoField.SECOND_OF_MINUTE) : 0;
        LocalDateTime output = !DateTimeFormatterUtil.canGetDate(taWithMissingFields) ? LocalDateTime.of(LocalDate.now(fp.getQueryStartClock()), LocalTime.of(hour, minute, second)) : LocalDateTime.of(year, month, day, hour, minute, second);
        return new ExprTimestampValue(output);
    }

    private static String getSuffix(int val) {
        if (11 <= val && val <= 13) {
            return SUFFIX_SPECIAL_TH;
        }
        return SUFFIX_CONVERTER.getOrDefault(val % 10, SUFFIX_SPECIAL_TH);
    }

    static interface DateTimeFormatHandler {
        public String getFormat(LocalDateTime var1);
    }
}

