/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.aggregation.AvgAggregator;
import org.opensearch.sql.expression.aggregation.CountAggregator;
import org.opensearch.sql.expression.aggregation.MaxAggregator;
import org.opensearch.sql.expression.aggregation.MinAggregator;
import org.opensearch.sql.expression.aggregation.PercentileApproximateAggregator;
import org.opensearch.sql.expression.aggregation.StdDevAggregator;
import org.opensearch.sql.expression.aggregation.SumAggregator;
import org.opensearch.sql.expression.aggregation.TakeAggregator;
import org.opensearch.sql.expression.aggregation.VarianceAggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public final class AggregatorFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(AggregatorFunctions.avg());
        repository.register(AggregatorFunctions.sum());
        repository.register(AggregatorFunctions.count());
        repository.register(AggregatorFunctions.min());
        repository.register(AggregatorFunctions.max());
        repository.register(AggregatorFunctions.varSamp());
        repository.register(AggregatorFunctions.varPop());
        repository.register(AggregatorFunctions.stddevSamp());
        repository.register(AggregatorFunctions.stddevPop());
        repository.register(AggregatorFunctions.take());
        repository.register(AggregatorFunctions.percentileApprox());
    }

    private static DefaultFunctionResolver avg() {
        FunctionName functionName = BuiltinFunctionName.AVG.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> new AvgAggregator(arguments2, ExprCoreType.DOUBLE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments2) -> new AvgAggregator(arguments2, ExprCoreType.DATE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments2) -> new AvgAggregator(arguments2, ExprCoreType.TIME)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments2) -> new AvgAggregator(arguments2, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver count() {
        FunctionName functionName = BuiltinFunctionName.COUNT.getName();
        DefaultFunctionResolver functionResolver = new DefaultFunctionResolver(functionName, ExprCoreType.coreTypes().stream().collect(Collectors.toMap(type2 -> new FunctionSignature(functionName, Collections.singletonList(type2)), type2 -> (functionProperties, arguments2) -> new CountAggregator(arguments2, ExprCoreType.LONG))));
        return functionResolver;
    }

    private static DefaultFunctionResolver sum() {
        FunctionName functionName = BuiltinFunctionName.SUM.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments2) -> new SumAggregator(arguments2, ExprCoreType.INTEGER)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments2) -> new SumAggregator(arguments2, ExprCoreType.LONG)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments2) -> new SumAggregator(arguments2, ExprCoreType.FLOAT)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> new SumAggregator(arguments2, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver min() {
        FunctionName functionName = BuiltinFunctionName.MIN.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.INTEGER)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.LONG)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.FLOAT)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.DOUBLE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.STRING)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.DATE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.TIME)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments2) -> new MinAggregator(arguments2, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver max() {
        FunctionName functionName = BuiltinFunctionName.MAX.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.INTEGER)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.INTEGER)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.LONG)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.LONG)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.FLOAT)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.FLOAT)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.DOUBLE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.STRING)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.STRING)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DATE)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.DATE)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIME)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.TIME)).put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.TIMESTAMP)), (functionProperties, arguments2) -> new MaxAggregator(arguments2, ExprCoreType.TIMESTAMP)).build());
    }

    private static DefaultFunctionResolver varSamp() {
        FunctionName functionName = BuiltinFunctionName.VARSAMP.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> VarianceAggregator.varianceSample(arguments2, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver varPop() {
        FunctionName functionName = BuiltinFunctionName.VARPOP.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> VarianceAggregator.variancePopulation(arguments2, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver stddevSamp() {
        FunctionName functionName = BuiltinFunctionName.STDDEV_SAMP.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> StdDevAggregator.stddevSample(arguments2, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver stddevPop() {
        FunctionName functionName = BuiltinFunctionName.STDDEV_POP.getName();
        return new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, Collections.singletonList(ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> StdDevAggregator.stddevPopulation(arguments2, ExprCoreType.DOUBLE)).build());
    }

    private static DefaultFunctionResolver take() {
        FunctionName functionName = BuiltinFunctionName.TAKE.getName();
        DefaultFunctionResolver functionResolver = new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.INTEGER)), (functionProperties, arguments2) -> new TakeAggregator(arguments2, ExprCoreType.ARRAY)).build());
        return functionResolver;
    }

    private static DefaultFunctionResolver percentileApprox() {
        FunctionName functionName = BuiltinFunctionName.PERCENTILE_APPROX.getName();
        DefaultFunctionResolver functionResolver = new DefaultFunctionResolver(functionName, new ImmutableMap.Builder<FunctionSignature, FunctionBuilder>().put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.INTEGER, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.INTEGER)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.INTEGER, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.INTEGER)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.LONG, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.LONG)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.LONG, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.LONG)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.FLOAT, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.FLOAT)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.FLOAT, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.FLOAT)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.DOUBLE, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.DOUBLE)).put(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE)), (functionProperties, arguments2) -> PercentileApproximateAggregator.percentileApprox(arguments2, ExprCoreType.DOUBLE)).build());
        return functionResolver;
    }

    @Generated
    private AggregatorFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

