/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.RangeFormatter;
import org.opensearch.sql.calcite.utils.binning.SpanInfo;

public class LogSpanHelper {
    public RexNode createLogSpanExpression(RexNode fieldExpr, SpanInfo spanInfo, CalcitePlanContext context) {
        double base = spanInfo.getBase();
        double coefficient = spanInfo.getCoefficient();
        RexNode positiveCheck = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, fieldExpr, context.relBuilder.literal(0.0));
        RexNode adjustedField = fieldExpr;
        if (coefficient != 1.0) {
            adjustedField = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, fieldExpr, context.relBuilder.literal(coefficient));
        }
        RexNode lnField = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.LN, adjustedField);
        RexLiteral lnBase = context.relBuilder.literal(Math.log(base));
        RexNode logValue = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, lnField, lnBase);
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, logValue);
        RexLiteral baseNode = context.relBuilder.literal(base);
        RexLiteral coefficientNode = context.relBuilder.literal(coefficient);
        RexNode basePowerBin = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, baseNode, binNumber);
        RexNode lowerBound = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, coefficientNode, basePowerBin);
        RexNode binPlusOne = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, binNumber, context.relBuilder.literal(1.0));
        RexNode basePowerBinPlusOne = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.POWER, baseNode, binPlusOne);
        RexNode upperBound = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, coefficientNode, basePowerBinPlusOne);
        RexNode rangeStr = RangeFormatter.createRangeString(lowerBound, upperBound, context);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, positiveCheck, rangeStr, context.relBuilder.literal("Invalid"));
    }
}

