/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.util.format.FormatElement;
import org.apache.calcite.util.format.FormatElementEnum;
import org.apache.calcite.util.format.FormatModel;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class FormatModels {
    public static final FormatModel DEFAULT;
    public static final FormatModel BIG_QUERY;
    public static final FormatModel POSTGRESQL;

    private FormatModels() {
    }

    private static Pattern regexFromMap(Map<String, FormatElement> elementMap) {
        StringBuilder regex = new StringBuilder();
        for (String key : elementMap.keySet()) {
            regex.append("(").append(Pattern.quote(key)).append(")|");
        }
        regex.setLength(regex.length() - 1);
        return Pattern.compile(regex.toString());
    }

    public static FormatModel create(Map<String, FormatElement> elementMap) {
        Pattern pattern = FormatModels.regexFromMap(elementMap);
        return new FormatModelImpl(pattern, elementMap);
    }

    public static FormatElement literalElement(String literal) {
        return new FormatModelElementLiteral(literal);
    }

    public static FormatElement compositeElement(String description2, FormatElement ... fmtElements) {
        return new CompositeFormatElement(ImmutableList.copyOf(fmtElements), description2);
    }

    static {
        LinkedHashMap<String, FormatElement> map = new LinkedHashMap<String, FormatElement>();
        for (FormatElementEnum fe : FormatElementEnum.values()) {
            map.put(fe.toString(), fe);
        }
        DEFAULT = FormatModels.create(map);
        map.clear();
        map.put("%A", FormatElementEnum.Day);
        map.put("%a", FormatElementEnum.Dy);
        map.put("%B", FormatElementEnum.Month);
        map.put("%b", FormatElementEnum.Mon);
        map.put("%c", FormatModels.compositeElement("The date and time representation (English);", FormatElementEnum.Dy, FormatModels.literalElement(" "), FormatElementEnum.Mon, FormatModels.literalElement(" "), FormatElementEnum.DD, FormatModels.literalElement(" "), FormatElementEnum.HH24, FormatModels.literalElement(":"), FormatElementEnum.MI, FormatModels.literalElement(":"), FormatElementEnum.SS, FormatModels.literalElement(" "), FormatElementEnum.YYYY));
        map.put("%d", FormatElementEnum.DD);
        map.put("%E1S", FormatElementEnum.FF1);
        map.put("%E2S", FormatElementEnum.FF2);
        map.put("%E3S", FormatElementEnum.FF3);
        map.put("%E4S", FormatElementEnum.FF4);
        map.put("%E5S", FormatElementEnum.FF5);
        map.put("%E*S", FormatElementEnum.FF6);
        map.put("%e", FormatElementEnum.E);
        map.put("%F", FormatModels.compositeElement("The date in the format %Y-%m-%d.", FormatElementEnum.YYYY, FormatModels.literalElement("-"), FormatElementEnum.MM, FormatModels.literalElement("-"), FormatElementEnum.DD));
        map.put("%G", FormatElementEnum.IYYYY);
        map.put("%g", FormatElementEnum.IYY);
        map.put("%H", FormatElementEnum.HH24);
        map.put("%I", FormatElementEnum.HH12);
        map.put("%j", FormatElementEnum.DDD);
        map.put("%M", FormatElementEnum.MI);
        map.put("%m", FormatElementEnum.MM);
        map.put("%p", FormatElementEnum.PM);
        map.put("%Q", FormatElementEnum.Q);
        map.put("%R", FormatModels.compositeElement("The time in the format %H:%M", FormatElementEnum.HH24, FormatModels.literalElement(":"), FormatElementEnum.MI));
        map.put("%S", FormatElementEnum.SS);
        map.put("%T", FormatModels.compositeElement("The time in the format %H:%M:%S.", FormatElementEnum.HH24, FormatModels.literalElement(":"), FormatElementEnum.MI, FormatModels.literalElement(":"), FormatElementEnum.SS));
        map.put("%u", FormatElementEnum.ID);
        map.put("%V", FormatElementEnum.IW);
        map.put("%W", FormatElementEnum.WW);
        map.put("%x", FormatModels.compositeElement("The date representation in MM/DD/YY format", FormatElementEnum.MM, FormatModels.literalElement("/"), FormatElementEnum.DD, FormatModels.literalElement("/"), FormatElementEnum.YY));
        map.put("%Y", FormatElementEnum.pctY);
        map.put("%y", FormatElementEnum.YY);
        map.put("%Z", FormatElementEnum.TZR);
        map.put("HH12", FormatElementEnum.HH12);
        map.put("HH24", FormatElementEnum.HH24);
        map.put("MI", FormatElementEnum.MI);
        map.put("SSSSS", FormatElementEnum.SSSSS);
        map.put("SS", FormatElementEnum.SS);
        map.put("MS", FormatElementEnum.MS);
        map.put("FF1", FormatElementEnum.FF1);
        map.put("FF2", FormatElementEnum.FF2);
        map.put("FF3", FormatElementEnum.FF3);
        map.put("FF4", FormatElementEnum.FF4);
        map.put("FF5", FormatElementEnum.FF5);
        map.put("FF6", FormatElementEnum.FF6);
        map.put("FF7", FormatElementEnum.FF7);
        map.put("FF8", FormatElementEnum.FF8);
        map.put("FF9", FormatElementEnum.FF9);
        map.put("YYYY", FormatElementEnum.YYYY);
        map.put("YYY", FormatElementEnum.YYY);
        map.put("YY", FormatElementEnum.YY);
        map.put("Y", FormatElementEnum.Y);
        map.put("RRRR", FormatElementEnum.YYYY);
        map.put("RR", FormatElementEnum.YY);
        map.put("DAY", FormatElementEnum.DAY);
        map.put("Day", FormatElementEnum.Day);
        map.put("day", FormatElementEnum.day);
        map.put("DY", FormatElementEnum.DY);
        map.put("Dy", FormatElementEnum.Dy);
        map.put("dy", FormatElementEnum.dy);
        map.put("month", FormatElementEnum.month);
        map.put("Month", FormatElementEnum.Month);
        map.put("MONTH", FormatElementEnum.MONTH);
        map.put("mon", FormatElementEnum.mon);
        map.put("Mon", FormatElementEnum.Mon);
        map.put("MON", FormatElementEnum.MON);
        map.put("MM", FormatElementEnum.MM);
        map.put("CC", FormatElementEnum.CC);
        map.put("DDD", FormatElementEnum.DDD);
        map.put("DD", FormatElementEnum.DD);
        map.put("D", FormatElementEnum.D);
        map.put("WW", FormatElementEnum.WW);
        map.put("W", FormatElementEnum.W);
        map.put("IW", FormatElementEnum.IW);
        map.put("Q", FormatElementEnum.Q);
        map.put("AM", FormatElementEnum.AMPM);
        map.put("A.M.", FormatElementEnum.AM_PM);
        map.put("am", FormatElementEnum.ampm);
        map.put("a.m.", FormatElementEnum.am_pm);
        map.put("PM", FormatElementEnum.AMPM);
        map.put("P.M.", FormatElementEnum.AM_PM);
        map.put("pm", FormatElementEnum.ampm);
        map.put("p.m.", FormatElementEnum.am_pm);
        map.put("TZ", FormatElementEnum.TZR);
        LinkedHashMap lowercaseMap = new LinkedHashMap();
        map.forEach((key, value) -> {
            String lowerKey = key.toLowerCase(Locale.ROOT);
            if (!map.containsKey(lowerKey)) {
                lowercaseMap.put(lowerKey, value);
            }
        });
        map.putAll(lowercaseMap);
        BIG_QUERY = FormatModels.create(map);
        POSTGRESQL = FormatModels.create(map);
    }

    private static class CompositeFormatElement
    implements FormatElement {
        private final String description;
        private final List<FormatElement> formatElements;

        CompositeFormatElement(List<FormatElement> formatElements, String description2) {
            this.formatElements = ImmutableList.copyOf(formatElements);
            this.description = Objects.requireNonNull(description2, "description");
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            this.flatten(ele -> ele.format(sb, date));
        }

        @Override
        public void toPattern(StringBuilder sb) {
            this.flatten(ele -> ele.toPattern(sb));
        }

        @Override
        public void flatten(Consumer<FormatElement> consumer) {
            this.formatElements.forEach(consumer);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class FormatModelElementLiteral
    implements FormatElement {
        private final String literal;

        FormatModelElementLiteral(String literal) {
            this.literal = Objects.requireNonNull(literal, "literal");
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            sb.append(this.literal);
        }

        @Override
        public void toPattern(StringBuilder sb) {
            sb.append(this.literal);
        }

        @Override
        public String getDescription() {
            return "Represents literal text in a format string";
        }

        public String toString() {
            return this.literal;
        }
    }

    private static class FormatModelImpl
    implements FormatModel {
        final Pattern pattern;
        final Map<String, FormatElement> elementMap;
        final Map<String, List<FormatElement>> memoizedElements = new ConcurrentHashMap<String, List<FormatElement>>();

        FormatModelImpl(Pattern pattern, Map<String, FormatElement> elementMap) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.elementMap = ImmutableMap.copyOf(elementMap);
        }

        @Override
        public Map<String, FormatElement> getElementMap() {
            return this.elementMap;
        }

        @Override
        public List<FormatElement> parseNoCache(String format) {
            String literal;
            ImmutableList.Builder elements = ImmutableList.builder();
            Matcher matcher = this.pattern.matcher(format);
            int i = 0;
            while (matcher.find()) {
                literal = format.substring(i, matcher.start());
                if (!literal.isEmpty()) {
                    elements.add(FormatModels.literalElement(literal));
                }
                String key = matcher.group();
                elements.add(this.getElementMap().getOrDefault(key, FormatModels.literalElement(key)));
                i = matcher.end();
            }
            literal = format.substring(i);
            if (!literal.isEmpty()) {
                elements.add(FormatModels.literalElement(literal));
            }
            return elements.build();
        }

        @Override
        public List<FormatElement> parse(String format) {
            return this.memoizedElements.computeIfAbsent(format, this::parseNoCache);
        }
    }
}

