/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.hint;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.HintPredicate;
import org.apache.calcite.rel.hint.RelHint;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public class CompositeHintPredicate
implements HintPredicate {
    private final ImmutableList<HintPredicate> predicates;
    private final Composition composition;

    CompositeHintPredicate(Composition composition, HintPredicate ... predicates) {
        this.predicates = ImmutableList.copyOf(predicates);
        Preconditions.checkArgument(this.predicates.size() > 1);
        this.composition = composition;
    }

    @Override
    public boolean apply(RelHint hint, RelNode rel) {
        return this.apply(this.composition, hint, rel);
    }

    private boolean apply(Composition composition, RelHint hint, RelNode rel) {
        switch (composition) {
            case AND: {
                for (HintPredicate predicate : this.predicates) {
                    if (predicate.apply(hint, rel)) continue;
                    return false;
                }
                return true;
            }
        }
        for (HintPredicate predicate : this.predicates) {
            if (!predicate.apply(hint, rel)) continue;
            return true;
        }
        return false;
    }

    public static enum Composition {
        AND,
        OR;

    }
}

