/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.CipherHandler;
import com.amazonaws.encryptionsdk.internal.CryptoHandler;
import com.amazonaws.encryptionsdk.internal.ProcessingSummary;
import com.amazonaws.encryptionsdk.internal.Utils;
import com.amazonaws.encryptionsdk.model.CipherFrameHeaders;
import java.util.Arrays;
import javax.crypto.SecretKey;

class FrameDecryptionHandler
implements CryptoHandler {
    private final SecretKey decryptionKey_;
    private final CryptoAlgorithm cryptoAlgo_;
    private final CipherHandler cipherHandler_;
    private final byte[] messageId_;
    private final short nonceLen_;
    private CipherFrameHeaders currentFrameHeaders_;
    private final int frameSize_;
    private long frameNumber_ = 1L;
    boolean complete_ = false;
    private byte[] unparsedBytes_ = new byte[0];

    public FrameDecryptionHandler(SecretKey decryptionKey, short nonceLen, CryptoAlgorithm cryptoAlgo, byte[] messageId, int frameLen) {
        this.decryptionKey_ = decryptionKey;
        this.nonceLen_ = nonceLen;
        this.cryptoAlgo_ = cryptoAlgo;
        this.messageId_ = messageId;
        this.frameSize_ = frameLen;
        this.cipherHandler_ = new CipherHandler(this.decryptionKey_, 2, this.cryptoAlgo_);
    }

    @Override
    public ProcessingSummary processBytes(byte[] in, int off, int len, byte[] out, int outOff) throws BadCiphertextException, AwsCryptoException {
        if (this.complete_) {
            throw new AwsCryptoException("Ciphertext has already been processed.");
        }
        long totalBytesToParse = (long)this.unparsedBytes_.length + (long)len;
        if (totalBytesToParse > Integer.MAX_VALUE) {
            throw new AwsCryptoException("Integer overflow of the total bytes to parse and decrypt occured.");
        }
        byte[] bytesToParse = new byte[(int)totalBytesToParse];
        System.arraycopy(this.unparsedBytes_, 0, bytesToParse, 0, this.unparsedBytes_.length);
        System.arraycopy(in, off, bytesToParse, this.unparsedBytes_.length, len);
        int actualOutLen = 0;
        int totalParsedBytes = 0;
        while (!this.complete_ && totalParsedBytes < bytesToParse.length) {
            if (this.currentFrameHeaders_ == null) {
                this.currentFrameHeaders_ = new CipherFrameHeaders();
                this.currentFrameHeaders_.setNonceLength(this.nonceLen_);
                if (this.frameSize_ == 0) {
                    this.currentFrameHeaders_.includeFrameSize(true);
                }
            }
            totalParsedBytes += this.currentFrameHeaders_.deserialize(bytesToParse, totalParsedBytes);
            if (!this.currentFrameHeaders_.isComplete()) break;
            int protectedContentLen = -1;
            if (this.currentFrameHeaders_.isFinalFrame()) {
                protectedContentLen = this.currentFrameHeaders_.getFrameContentLength();
                if (this.frameSize_ > 0 && protectedContentLen > this.frameSize_) {
                    throw new BadCiphertextException("Final frame length exceeds frame length.");
                }
            } else {
                protectedContentLen = this.frameSize_;
            }
            if (bytesToParse.length - totalParsedBytes < (protectedContentLen += this.cryptoAlgo_.getTagLen())) break;
            byte[] bytesToDecrypt_ = Arrays.copyOfRange(bytesToParse, totalParsedBytes, totalParsedBytes + protectedContentLen);
            totalParsedBytes += protectedContentLen;
            if (this.frameNumber_ == 0xFFFFFFFFL) {
                throw new BadCiphertextException("Frame number exceeds the maximum allowed value.");
            }
            byte[] decryptedBytes = this.decryptContent(bytesToDecrypt_, 0, bytesToDecrypt_.length);
            System.arraycopy(decryptedBytes, 0, out, outOff + actualOutLen, decryptedBytes.length);
            actualOutLen += decryptedBytes.length;
            ++this.frameNumber_;
            this.complete_ = this.currentFrameHeaders_.isFinalFrame();
            this.currentFrameHeaders_ = null;
        }
        if (!this.complete_) {
            this.unparsedBytes_ = Arrays.copyOfRange(bytesToParse, totalParsedBytes, bytesToParse.length);
            return new ProcessingSummary(actualOutLen, len);
        }
        ProcessingSummary result2 = new ProcessingSummary(actualOutLen, totalParsedBytes - this.unparsedBytes_.length);
        this.unparsedBytes_ = new byte[0];
        return result2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        if (!this.complete_) {
            throw new BadCiphertextException("Unable to process entire ciphertext.");
        }
        return 0;
    }

    @Override
    public int estimateOutputSize(int inLen) {
        int outSize = 0;
        int totalBytesToDecrypt = this.unparsedBytes_.length + inLen;
        if (totalBytesToDecrypt > 0) {
            int frames = totalBytesToDecrypt / this.frameSize_;
            outSize += this.frameSize_ * ++frames;
        }
        return outSize;
    }

    @Override
    public int estimatePartialOutputSize(int inLen) {
        return this.estimateOutputSize(inLen);
    }

    @Override
    public int estimateFinalOutputSize() {
        return 0;
    }

    private byte[] decryptContent(byte[] input, int off, int len) throws BadCiphertextException {
        byte[] nonce = this.currentFrameHeaders_.getNonce();
        byte[] contentAad = null;
        contentAad = this.currentFrameHeaders_.isFinalFrame() ? Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Final Frame", (int)this.frameNumber_, this.currentFrameHeaders_.getFrameContentLength()) : Utils.generateContentAad(this.messageId_, "AWSKMSEncryptionClient Frame", (int)this.frameNumber_, this.frameSize_);
        return this.cipherHandler_.cipherData(nonce, contentAad, input, off, len);
    }

    @Override
    public boolean isComplete() {
        return this.complete_;
    }
}

